# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

from urllib import urlencode
from xml.etree import ElementTree

from travel.avia.library.python.common.models.geo import Country
from travel.avia.library.python.common.utils.http import urlopen
from travel.avia.library.python.common.utils.safe_xml_parser import get_xml_safe_parser


inflector_url = 'http://export.yandex.ru/inflect.xml'


def inflect(name):
    params = [
        ('name', name.encode('utf-8')),
    ]

    stream = urlopen(inflector_url + '?' + urlencode(params))
    tree = ElementTree.parse(stream, parser=get_xml_safe_parser())
    stream.close()

    for inflection in tree.findall('inflection'):
        if inflection.get('case') == '2':
            return inflection.text

    return name


def run():
    for country in Country.objects.filter(title_of__isnull=True):
        country.title_of = inflect(country.title)
        country.save()


def main():
    run()
