# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

from itertools import chain

from django.db.models import Q

from travel.avia.library.python.common.models.geo import Settlement, Station
from travel.avia.admin.www.utils.language import city_preposition_locative


def run():
    conditions = Q(title_ru_preposition_v_vo_na__isnull=True, title_ru_locative__isnull=False)

    empty_settlements = Settlement.objects.filter(conditions)
    empty_stations = Station.objects.filter(conditions)

    for obj in chain(empty_settlements, empty_stations):
        obj.title_ru_preposition_v_vo_na = city_preposition_locative(obj.title_ru_locative)
        obj.save()


def main():
    run()
