# -*- encoding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import os
import logging
import time as os_time

from django.db import connection, transaction

from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout
from travel.avia.library.python.common.models.geo import Settlement


log = logging.getLogger(__name__)


@transaction.atomic
def run():
    log.info(u'Запускаем %s', os.path.basename(__file__))
    cursor = connection.cursor()
    t_start = os_time.time()

    log.info(u'Поднимаем важность станции, если через нее проходит 3 и больше поднаправлений')
    cursor.execute("""
    CREATE TEMPORARY TABLE xxx
        SELECT rts.station_id, COUNT(DISTINCT rts.departure_subdir) c
            FROM www_rtstation rts
            WHERE rts.tz_departure IS NOT NULL AND rts.departure_subdir IS NOT NULL
            GROUP BY rts.station_id HAVING c >= 3
    """)
    cursor.execute("""
    UPDATE www_station, xxx
        SET majority_id = 3
        WHERE www_station.id = xxx.station_id AND www_station.majority_id >= 4;
    """)

    log.info(u'Устанавливаем временную зону и страну населенного пункта через регион')
    cursor.execute("""UPDATE www_settlement sett
    LEFT JOIN www_region reg ON reg.id = sett.region_id
    SET sett.time_zone=reg.time_zone
    WHERE region_id IS NOT NULL AND sett.time_zone IS NULL AND
    reg.time_zone IS NOT NULL;""")
    cursor.execute("""UPDATE www_settlement sett
    JOIN www_region reg ON reg.id = sett.region_id
    SET sett.country_id = reg.country_id
    WHERE sett.region_id IS NOT NULL AND reg.country_id IS NOT NULL""")

    Settlement.objects.all().update(hidden=True)
    Settlement.objects.filter(station__hidden=False).update(hidden=False)
    Settlement.objects.filter(station2settlement__station__hidden=False).update(hidden=False)

    Settlement.objects.filter(
        station__hidden=False,
        station__rtstation__thread__route__t_type__code__in=['train', 'plane'],
        station__rtstation__thread__route__hidden=False
    ).update(has_tablo=True)

    cursor.execute("UPDATE www_settlement SET majority_id=99 WHERE majority_id IS NULL")

    log.info(u'Обновляем поле hidden в регионах')
    cursor.execute("UPDATE www_region SET hidden = 0")
    cursor.execute(
        """UPDATE www_region
         LEFT JOIN www_settlement
          ON www_settlement.region_id = www_region.id AND www_settlement.hidden = 0
         LEFT JOIN www_station
          ON www_station.region_id = www_region.id AND www_station.hidden = 0
        SET www_region.hidden=1
        WHERE www_settlement.id IS NULL AND www_station.id IS NULL"""
    )

    log.info(u'Привязываем населенные пункты к странам через регион')
    for settlement in Settlement.objects.filter(country=None):
        if settlement.region and settlement.region.country:
            settlement.country = settlement.region.country
            settlement.save()

    log.info(u'Done %s sec.', int(os_time.time() - t_start))


def main():
    create_current_file_run_log()
    import argparse

    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true', help=u'Print log to stdout')
    args = parser.parse_args()

    if args.verbose:
        print_log_to_stdout()

    run()
