# -*- encoding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import sys
import os.path
import getopt
import logging

from travel.avia.library.python.common.models.geo import Settlement, Station2Settlement
from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log
from travel.avia.library.python.common.lib.mail import mail_process

script_name = os.path.basename(__file__)

log = logging.getLogger(__name__)

usage = """
Usage: python %(script_name)s [-v]
""" % {
    'script_name': script_name
    }


def r_t(settlement):
    return settlement.region and settlement.region.title


def run():
    bad_settlements = []
    for settlement in Settlement.objects.filter(hidden=False).select_related():
        stations = settlement.station_set.filter(majority__id__lt=3,
                                                 hidden=False)
        region = settlement.region and settlement.region.title
        if not stations:
            stations = settlement.station_set.filter(hidden=False)
            if not stations:
                stations = Station2Settlement.objects.filter(settlement=settlement)
                if not stations:
                    log.error(u"!!!!В городе %s %s вообще нет станций с важностью выше непопадает в табло, но он не скрыт",
                              settlement.id, settlement.title)
            elif len(stations) == 1:
                station = stations[0]
                # Если это жд-станция или аэропорт
                if station.t_type_id in (1, 2):
                    station.majority_id = 1
                    log.info(u"Станции %s %s в городе %s %s %s подняли важность до главной в городе",
                             station.id, station.title, settlement.id, settlement.title,
                             region)
                station.save()

            else:
                bad_settlements.append(settlement)
                log.warning(u"В городе %s %s (%s) несколько нескрытых не попадающих в табло станций",
                            settlement.id, settlement.title, region)

    message = u"\n".join([u"%s %s (%s)" % (s.id, s.title, r_t(s)) for s in bad_settlements])
    if message:
        mail_process(u"Города с несколькими нескрытыми, непопадающими в табло станциями",
                      message)


def main():
    create_current_file_run_log()

    error = False
    try:
        options, args = getopt.gnu_getopt(
            sys.argv[1:], 'v', ['verbose']
            )
        for option in options:
            key, value = option
            if key in ('-v', '--verbose'):
                print_log_to_stdout(log)

    except getopt.GetoptError as e:
        error = unicode(e)

    if error:
        log.error(u'Проблема запуска скрипта: %s', error)
        print error
        print usage
        sys.exit(1)

    run()
