# -*- coding: utf-8 -*-
# Django settings for avia admin
from collections import defaultdict

import pytz  # noqa

import sys
import os
import datetime
import socket

from django.utils.translation import ugettext_lazy as _  # noqa
from library.python.django.utils import patch_settings_for_arcadia

from travel.avia.library.python.common.settings import *  # noqa
from travel.avia.admin.migration_settings import *  # noqa


RASP_PROJECT = 'admin'
ALLOWED_HOSTS = [
    os.getenv('DJANGO_ALLOWED_HOSTS', '.yandex-team.ru'),
]
ENVIRONMENT = 'dev'

EMAIL_HOST = 'localhost'
EMAIL_SUBJECT_PREFIX = '[Django-rasp@%s] ' % socket.gethostname()
DEFAULT_FROM_EMAIL = 'rasp-tech@yandex-team.ru'
SERVER_EMAIL = 'Rasp at %s <rasp-tech@yandex-team.ru>' % socket.gethostname()

DEBUG = False
DEBUG_PROPAGATE_EXCEPTIONS = False
TEMPLATE_DEBUG = False

HOST_URL = 'https://admin.avia.yandex-team.ru'
SCRIPT_REPORTER_MAIL = 'avia-script-reports@yandex-team.ru'

try:
    import pwd

    current_user = ('Current User', '%s@yandex-team.ru' % pwd.getpwuid(os.getuid())[0])
except Exception:
    username = os.environ.get('USERNAME', os.environ.get('LOGNAME'))
    if username:
        current_user = ('Current User', '%s@yandex-team.ru' % username)
    else:
        current_user = ('Current User', 'none')

CURRENT_USER_NAME = current_user[1]

TESTERS = MANAGERS = ADMINS = (current_user, )
DATACHANGE_RCPNTS = PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
EXPERSS_SUBST_RCPNTS = UNKNOWN_CODES_RCPNTS = RASP_FREE_STATIONS_RCPNTS = ADMINS

ERRORS_RECIPIENTS = [current_user[1]]

# Основные директории проекта
PROJECT_PATH = os.path.normpath(os.path.abspath(os.path.dirname(__file__)))
SCRIPTS_PATH = os.path.normpath(os.path.join(PROJECT_PATH, 'scripts'))
AVIA_SCRIPTS_PATH = os.path.normpath(os.path.join(PROJECT_PATH, 'avia/scripts'))
EXPORT_PATH = os.path.join(PROJECT_PATH, 'www/db/scripts/export')
EXPORT_PUBLIC_PATH = os.path.join(EXPORT_PATH, 'public')
EXPORT_SUBURBAN_PATH = os.path.join(EXPORT_PATH, 'suburban')
EXPORT_URBAN_PUBLIC_PATH = os.path.join(EXPORT_PATH, 'long_haul')
DATA_PATH = os.path.join(PROJECT_PATH, 'www/db/scripts/data')
PATHFINDDER_DATA_PATH = os.path.join(DATA_PATH, 'pathfinder')

CACHE_PATH = os.getenv('CACHE_PATH', '/var/cache/avia/')

IS_BLANK_TEST_DB = False

MYSQL_CONNECT_TIMEOUT = MYSQL_READ_TIMEOUT = MYSQL_WRITE_TIMEOUT = 3600 * 5  # для особо долгих скриптов

# FIXME: Тоже дублируются в коммоне, но под другими именами
BILLING_HOST = 'mbi1gt.market.yandex.net'  # хост биллинга
BILLING_PORT = 34861             # порт
BILLING_SERVICE_ID = 114         # номер нашего сервиса в биллинге

# отправлять ли уведомления об изменениях времени рейса
SEND_CHANGES_REMINDERS = False
# хост для отправки уведомлений
REMINDERS_HOST = 'reminders-api.tardis.dev.yandex.net'

SERVICE_INSTANCE = os.path.exists(os.path.join(PROJECT_PATH, 'service.flag'))
MIGRATION_INSTANCE = os.path.exists(os.path.join(PROJECT_PATH, 'migration.flag'))


def dc_cache(hosts):
    return {
        'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
        'LOCATION': ['%s:11211' % host for host in hosts],
        'TIMEOUT': 60,
        'LONG_TIMEOUT': 24 * 60 * 60,
    }


CACHES = {
    'default': dc_cache(['localhost'])
}


TIME_ZONE = 'Europe/Moscow'

USE_I18N = True
# Для нормальной работы админки
USE_L10N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = '/app/media'

LOCALE_PATHS = [
    os.path.join(PROJECT_PATH, 'api', 'js-locale'),
    os.path.join(PROJECT_PATH, 'admin', 'locale'),
]

DEFAULT_FILE_STORAGE = "travel.avia.library.python.common.utils.fields.TransliteratingFileSystemStorage"
FILEBROWSER_DIRECTORY = 'data/static/'
FILEBROWSER_VERSIONS_BASEDIR = 'data/_fb_versions/'
FILEBROWSER_ADMIN_VERSIONS = ['admin_thumbnail']
FILEBROWSER_VERSIONS = {
    'admin_thumbnail': {'verbose_name': 'Admin Thumbnail', 'width': 80, 'height': 80, 'opts': 'crop'}
}

JINJA_EXTS = ['jinja2.ext.i18n']

JINJA_CONTEXT_PROCESSORS = (
    'django.template.context_processors.debug',
    'django.template.context_processors.media',
    'django.template.context_processors.request',
    'travel.avia.admin.www.context.default',
)

JINJA_LIBRARIES = (
    'travel.avia.admin.www.templatetags.block_found_routes',
    'travel.avia.admin.www.templatetags.block_thread',
    'travel.avia.admin.www.templatetags.common',
    'travel.avia.admin.www.templatetags.durations',
    'travel.avia.admin.www.templatetags.html',
    'travel.avia.admin.www.templatetags.timezones',
    'travel.avia.admin.currency.templatefilters',
)

JINJA_GLOBALS = (
    '__builtin__.min',
    '__builtin__.reversed',
    'datetime.timedelta',
    # 'django_russian.utils.qadjective',
    # 'django_russian.utils.qnoun',
    # 'django_russian.utils.qverb',
    'itertools.chain',
    'travel.avia.admin.lib.translation.gettext',
    'math.floor',
    'math.ceil',
    'pytils.numeral.get_plural',
    'random.randint',
    'travel.avia.admin.www.templatetags.block_tablo.geo_data',
    'travel.avia.admin.www.templatetags.block_tablo.weather_city',
    'travel.avia.admin.www.templatetags.block_tablo.weather_data',
    'travel.avia.admin.www.templatetags.block_thread.wrong_date_disclaimer',
    'travel.avia.admin.www.templatetags.common.media_url',
    'travel.avia.admin.www.templatetags.tablo_sett_navigation.tablo_sett_nav_objects',
)

JINJA_FILTERS = (
    'django.template.defaultfilters.capfirst',
    'django.template.defaultfilters.date',
    'django.template.defaultfilters.urlencode',
    # 'django_russian.templatetags.russian.human_date',
    # 'django_russian.templatetags.russian.human_duration',
    # 'django_russian.templatetags.russian.quantity',
    'pytils.templatetags.pytils_dt.ru_strftime',
    'travel.avia.admin.www.templatetags.block_tablo.one_station_title',
    'travel.avia.admin.www.templatetags.block_tablo.translate_wind_direction',
    'travel.avia.admin.www.templatetags.block_thread.bold_duration',
    'travel.avia.admin.www.templatetags.filters.ins_nbsp',
    )

JINJA_TEMPLATE_DIRS = [
    'travel/avia/admin/templates/jinja'
]

TEMPLATES = [{
    'BACKEND': 'django.template.backends.django.DjangoTemplates',
    'DIRS': [
        'trave/avia/admin/avia_scripts/templates',
    ],
    'APP_DIRS': False,
    'OPTIONS': {
        'context_processors': [
            'django.contrib.auth.context_processors.auth',
            'django.template.context_processors.debug',
            'django.template.context_processors.media',
            'django.template.context_processors.request',
            'django.template.context_processors.static',
            'django.contrib.messages.context_processors.messages',
            'travel.avia.admin.www.context.default',
        ],
    }
}]

MIDDLEWARE_CLASSES = (
    'travel.avia.library.python.common.middleware.request_activator.RequestActivator',
    'travel.avia.library.python.common.middleware.now.Now',

    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.middleware.gzip.GZipMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.security.SecurityMiddleware',

    'travel.avia.admin.lib.mda.MDAMiddleware',
    'travel.avia.admin.www.middleware.AdminAuth',
    'travel.avia.admin.www.middleware.Language',
    'simple_history.middleware.HistoryRequestMiddleware',

)

ROOT_URLCONF = 'travel.avia.admin.urls'

INSTALLED_APPS = (
    # 'django_russian',
    # ??? 'django_tune',

    # Общие модули
    'travel.avia.library.python.common',
    'travel.avia.library.python.avia_data',
    'travel.avia.admin.avia_data_admin',

    # Локальные приложения
    'travel.avia.admin.feature_flag_app',
    'travel.avia.admin.staticpages',
    'travel.avia.admin.www',
    'travel.avia.admin.importinfo',
    'travel.avia.admin.currency',
    'travel.avia.admin.i18n',
    'travel.avia.admin.tariffs',
    'travel.avia.admin.order',
    'travel.avia.admin.stats',
    'travel.avia.admin.api',

    # Дополнения к админке
    'travel.avia.admin.admin',
    'travel.avia.admin.admin.www_stations',

    'travel.avia.admin.avia',

    # Сторонние приложения
    'pytils',
    'simple_history',
    'raven.contrib.django.raven_compat',

    # Чтобы работали переопределения шаблонов, django нужно включать позже
    'filebrowser',
    'django_yauth',
    'django.contrib.staticfiles',
    'django.contrib.auth',
    'django.contrib.admin',
    'django.contrib.humanize',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django_idm_api',
)


LOGIN_URL = '/admin/'

try:
    from django_yauth.settings import *  # noqa
    YAUTH_USE_NATIVE_USER = True

    YAUTH_TYPE = 'intranet'
    YAUTH_BACKEND = 'blackbox'

    import blackbox  # noqa

except ImportError:
    pass


PKG_VERSION = os.getenv('QLOUD_DOCKER_IMAGE') or datetime.datetime.today().strftime('dev.%Y%m%d%H%M%S')

# URL that handles the media served from MEDIA_ROOT.
# Example: "http://media.lawrence.com"
MEDIA_URL = '/media/'
MARKUP_URL = '/static/markup/'

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".

CACHEROOT = '/yandex/rasp-service/%s/' % PKG_VERSION

STATIC_URL = '/static/'

STATIC_ROOT = '/app/static'

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
]

SERVE_STATIC_BY_GUNICORN = False

DISABLE_PRECACHE = True

RSYNC = '/usr/bin/rsync'

PATHFINDER_TIMEOUT = .5

FILE_UPLOAD_PERMISSIONS = 0644

DISABLE_YAUTH = False

# Настройки танкера
TANKER_TOKENS = {
    'stable': '1f253c6acbdf41f79dcb5ef5f097785a',
    'testing': '88bb1e53128e4e6da78eba6c91659c49',
}

TANKER_KEYSETS = {
    'admin': ('admin/locale', ['ru', 'en'])
}


ADMIN_LANGUAGES = ['ru', 'en']

MODEL_LANGUAGES = ['ru', 'en', 'tr', 'uk']  # Добавлен английский, fallback для турецких названий

FORM_LANGUAGES = ['ru', 'en', 'tr', 'uk', 'kk', 'de']
# keep ASC order by period weight
SERVICEMETRICS_PERIODS = ['hour', 'day', 'month', 'year']
SERVICEMETRICS_SERVICES = {
    'ticket': u'Авиабилеты',
    'rasp': u'Расписания',
}

# Джанговские настройки для языков
# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'ru'

BASE_LANGUAGE = 'ru'

CLEAN_TMP = True

PAGES_ROOT = os.path.join(os.path.dirname(__file__), 'markup', 'pages-desktop')

if MIGRATION_INSTANCE:
    from travel.avia.library.python.common.settings.misc import MigrationInstance
    INSTANCE_ROLE = MigrationInstance
elif SERVICE_INSTANCE:
    from travel.avia.library.python.common.settings.misc import ServiceInstance
    INSTANCE_ROLE = ServiceInstance
else:
    from travel.avia.library.python.common.settings.misc import WorkInstance
    INSTANCE_ROLE = WorkInstance


LOG_URL_PATHS = defaultdict(lambda: '/admin/logs/')
LOG_URL_PATH = LOG_URL_PATHS[INSTANCE_ROLE.code]

PATHFINDER_URL = 'http://localhost:8101/search',
ETC_PATH = '/etc/yandex/rasp'
LOG_PATH = os.getenv('LOG_PATH', '/var/log/yandex-avia-admin/')
DOMAIN_NAME = 'rasp-migration.admin.{}'.format(socket.gethostname()),


ADMIN_TASK_RUN_IN_SEPARATE_PROCESS = True

sys.path = filter(lambda p: p not in (ETC_PATH, PROJECT_PATH), sys.path)
sys.path.insert(0, ETC_PATH)
# сначала ищем local_settings в PROJECT_PATH
sys.path.insert(0, PROJECT_PATH)


SERIALIZATION_MODULES = {
    'test_yaml': 'lib.unittests.yaml_serializer',
    'json': 'travel.avia.library.python.common.utils.django_utils.utf8_json_serializer'
}

SECRET_SALT = os.getenv('AVIA_ADMIN_SECRET_SALT')

YT_PROXY = 'hahn.yt.yandex.net'
YT_DATA_SIZE_PER_JOB = 128 * 1024 * 1024

LOG_LEVEL_NAME = 'INFO'

REST_HOST = None
REST_TIMEOUT = 10
RASPADMIN_HOST = None

RAVEN_CONFIG = None
DIRTY_LANG_URL = None
AVIA_BACK_URL = None
AVIA_TICKETDAEMON_URL = None


from managed_settings import *  # noqa
from travel.avia.admin.tariffs.settings import *  # noqa
from travel.avia.admin.order.settings import *  # noqa
from environment_settings import *  # noqa
from travel.avia.library.python.avia_data.settings import *  # noqa
from travel.avia.admin.avia.settings import *  # noqa

MDS_S3_AVIA_ADMIN_BUCKET = 'avia-admin'
MDS_S3_ENDPOINT_URL = 'http://s3.mdst.yandex.net'

try:
    from package_settings import *  # noqa
except ImportError:
    from local_settings import *  # noqa

from configure_logs import configure_logs  # noqa

configure_logs(globals(), LOG_PATH, LOG_LEVEL_NAME)

CACHE_BACKEND = 'dummy://'

PROJECT_CODE = 'admin'

YT_PARTNER_BOOKING_ROOT = '//home/avia/logs/avia-partner-booking-log'
AVIA_NATIONAL_VERSIONS = ('ru', 'ua', 'tr', 'com', 'kz')

TEST_DB_NAME = os.environ.get('AVIA_ADMIN_MYSQL_TEST_DATABASE_NAME', None)

ALLOW_GEOBASE = True

S7_QUERY_PASSWORD = os.getenv('AVIA_ADMIN_S7_QUERY_RULE_PASS')
CHARTEROK_KEY = os.getenv('AVIA_ADMIN_CHARTEROK_KEY')
TOPAIRLINES_PASSWORD = os.getenv('AVIA_ADMIN_TOPAIRLINES_PASSWORD')
INTERNAL_API_PASSWORD = os.getenv('AVIA_ADMIN_INTERNAL_API_PASSWORD')
TRADEDOUBLER_TOKEN = os.getenv('AVIA_ADMIN_TRADEDOUBLER_TOKEN')

PARTNER_PROXY_LOGIN = os.getenv('AVIA_ADMIN_PARTNER_PROXY_LOGIN')
PARTNER_PROXY_PASSWORD = os.getenv('AVIA_ADMIN_PARTNER_PROXY_PASSWORD')

IDM_INSTANCE = 'production'

APPLICATION_BINARY = os.getenv('AVIA_ADMIN_APPLICATION_BINARY', '/app/app')

SANDBOX_OAUTH_TOKEN = os.getenv('AVIA_ADMIN_SANDBOX_OAUTH_TOKEN', '')

YAV_OAUTH_TOKEN = os.getenv('AVIA_ADMIN_YAV_OAUTH_TOKEN')

patch_settings_for_arcadia()
