(function() {
var FUTUREDAYS = 330,
    parsers, handlers;

// Autogenerated from dateparser/validator.js

parsers = [
    {
        expression: /^(\d{1,2})$/i,
        handler: 'day_handler'
    },
    {
        expression: /^(\d{1,2})[./-](\d{1,2})(?:[./-](\d{4}|\d\d))?$/i,
        handler: 'digital_handler'
    },
    {
        expression: /^(\d{4})-(\d{1,2})-(\d{1,2})(?:\s(\d{2}):(\d{2}):(\d{2}))?$/i,
        handler: 'ansi_handler'
    },
    {
        expression: /^(\d{1,2})\s*((?:мая|янв|дек|окт|июл|июн|апр|мар|февраля|июль|авг|ноя|фев|август|сен|декабря|июля|март|декабрь|июнь|июня|марта|январь|апрель|апреля|января|октябрь|октября|февраль|май|августа|сентября|сентябрь|ноября|ноябрь))(?:\s+(\d{4}|\d\d))?$/i,
        handler: 'human_handler'
    },
    {
        expression: /^(позавчера|вчера|сегодня|завтра|послезавтра|через\s+неделю|через\s+месяц|на\s+все\s+дни)$/i,
        handler: 'human_pointer_handler'
    },
    {
        expression: /^(понедельник|вторник|среда|четверг|пятница|суббота|воскресенье)$/i,
        handler: 'human_weekday_handler'
    }

];

handlers = {
    'range_handler': function () {
        for(var i = 0; i < arguments.length; i++) {
            if(!checkDates(arguments[i])) {
            return false;
            }
        }

        return true;
    },
    'human_handler': function (day, month, year) {
        // Месяц правильный подразумевается из регекспа
        if(day < 1 || day > 31) {
            return false;
        }

        return true;
    },
    'digital_handler': function (day, month, year) {
        if(day < 1 || day > 31 || month < 1 || month > 12) {
            return false;
        }

        return true;
    }
};

function checkDate(value) {
    // Убираем пробелы в начале и конце
    value = $.trim(value);

    // Проходим по всем регулярным выражениям, если какое-то совпадает,
    // значит формат даты - известен
    for(var i = 0; i < parsers.length; i++) {
        var parser = parsers[i];
        var match = parser.expression.exec(value);

        if(match) {
            if(parser.handler in handlers) {
                return handlers[parser.handler].apply(null, match.slice(1));
            } else {
                return true;
            }
        };
    }

    return false;
};

BEM.DOM.decl('b-ext-widget', {

    onSetMod : {

        js : function() {
            var $form = $('form.b-widget-new__body'),
                $radios = $form.find('.b-widget-new__col_type_transport .b-form-radio__button:not(.sea_label)'),
                url = $form.attr('action');

            $radios.click(function(e) {
                var $radio = $(this).find('.b-form-radio__radio');
                if (!$radio.attr('value')){
                    $form.attr('action', url);
                    return;
                }
                $form.attr('action', url + $radio.attr('value') + '/');
            });

            $('.sea_label').click(function() {
                $form.attr('action', url);
            });

            $('.b-form-button_mod_revert').click(function(e) {
                var from = $('#id642435'),
                    where = $('#id642942'),
                    fromVal = from.val(),
                    whereVal = where.val();

                from.val(whereVal);
                where.val(fromVal);
            })

            this.bindTo('click', this._onClick);

            var inputs = this.findBlocksInside({ blockName : 'b-form-input', modName : 'pick', modVal : 'yes' }),
                dateInputs = this.findBlocksInside({ blockName : 'b-form-input', modName : 'has-calendar', modVal : 'yes'}),
                today,
                futureLimit;

                this.from = inputs[0];
                this.to = inputs[1];

            this.when = dateInputs[0];
            this.returnDate = dateInputs[1];

                today = new Date();

                today.setHours(0);
                today.setMinutes(0);
                today.setSeconds(0);
                today.setMilliseconds(0);

                futureLimit = new Date(today.getTime());

                futureLimit.setDate(futureLimit.getDate() + FUTUREDAYS);

            this.when.setLimits(today, futureLimit);
            this.returnDate.setLimits(today, futureLimit);

            this.when.on('choose', function(e, date) {
                this.returnDate.setLimits(date, futureLimit);
            }, this);

                this.params.counter &&
                    this.bindTo('show', function(){
                        this.params.counter.unshift(this.domElem[0]);
                        w.apply('', this.params.counter);
                        this.unbindFrom('show');
                    });

                /* this.bindTo('container', 'submit', function() {
                    return this.validate();
                }); */
        }

    },

    _onClick : function () {

        if(this.hasMod('state', 'short'))
            this.setMod('state', 'full');

    }/* ,

    validate : function () {

        if($.trim(this.from.val()) == '') {
            alert("Укажите пункт отправления.");
            return false;
        }

        if($.trim(this.to.val()) == '') {
            alert("Укажите пункт прибытия.");
            return false;
        }

        if(this.from.keyVal() || this.to.keyVal()) {
            if(this.from.keyVal() == this.to.keyVal()) {
                alert("Пожалуйста, выберите различные пункты отправления и прибытия.");
                return false;
            }
        } else {
            if($.trim(this.from.val()) == $.time(this.to.val())) {
                alert("Пожалуйста, выберите различные пункты отправления и прибытия.");
                return false;
            }
        }

        if($.trim(this.when.val()) && !checkDate(this.when.val())) {
            alert('Некорректный формат даты отправления. Введите дату в формате: «13.09.2011».');
            return false;
        }

        if($.trim(this.returnDate.val()) && !checkDate(this.returnDate.val())) {
            alert('Некорректный формат даты возвращения. Введите дату в формате: «13.09.2011».');
            return false;
        }

        return true;

    } */
});

})();
