BEM.DOM.decl({ block: 'b-form-button', modName: 'mod', modVal: 'calendar' }, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            var open = false,
                calendar,
                date = new Date(this.params.date),
                earlyLimit = new Date(this.params['early-limit']);

            this.on('click', function(e) {

                if(!calendar) {
                    calendar = BEM.create('i-calendar', { 'early-limit': earlyLimit });

                    calendar.on('choose', function(e, date) {

                        var link = this.findBlockInside($('body'), { block: 'b-link', modName: 'type', modVal: 'return-date' }),
                            url = link.domElem.attr('href'),
                            formatted = BEM.blocks['i-time'].formatTime('date', date),
                            // неразрывный пробел вреден для полей ввода
                            plain = formatted.split('\u00a0').join(' '),
                            newLink = BEM.blocks['i-url'].changeParams(url, { when: plain });

                        window.open(newLink);

                    }, this);
                }

                /* TODO: нужно решить проблему с незакрыванием календаря при повторном клике по кнопке */
                calendar.toggle(this.domElem, date);

            });

        }

    }

});
