(function() {

var HTML = BEM.HTML,
    DOM = BEM.DOM,
    DAYNAMES = ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'вс'],
    MONTHNAMES = ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'],
    MONTHNAMESINFLECTED = ['января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'];

function compareMonths(a, b) {
    if(a.getFullYear() > b.getFullYear())
        return 1;

    if(a.getFullYear() < b.getFullYear())
        return -1;

    if(a.getMonth() > b.getMonth())
        return 1;

    if(a.getMonth() < b.getMonth())
        return -1;

    return 0;
}

DOM.decl({ name : 'b-form-input', modName : 'has-calendar', modVal : 'yes' }, {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            // перезатираем список месяцев и дней недели локализованными
            this.params.months && (MONTHNAMES = this.params.months);
            this.params.weekDays && (DAYNAMES = this.params.weekDays);

            this.today = new Date();

            this.today.setHours(0);
            this.today.setMinutes(0);
            this.today.setSeconds(0);
            this.today.setMilliseconds(0);

            this._month = new Date(this.today.getTime());
            this._month.setDate(1);

            this.setLimits(
                this.parseDate(this.params.earlierLimit),
                this.parseDate(this.params.laterLimit)
            );
        }
    },

    _toggleCalendar : function() {

        var popup = this._getCalendarPopup();

        if(popup.isShowed())
            popup.hide();
        else {
            this._selected = this.parseDate(this.val());

            if(this._selected && !this._isValidDate(this._selected))
                this._selected = null;

            if(this._selected) {
                this._month = new Date(this._selected.getTime());
                this._month.setDate(1);
            }

            this._buildCalendar();
            popup.show(this.elem('calendar'));
        }

    },

    _getCalendarPopup : function() {

        if(!this._calendarPopup) {
            this._calendarPopup = $(HTML.build({
                block : 'b-popupa',
                mods : { direction : 'fixed' },
                content : [
                    { elem : 'close' },
                    { elem : 'content' }
                ]
            })).bem('b-popupa');
        }

        return this._calendarPopup;

    },

    switchMonth : function(step) {

        this._month.setMonth(this._month.getMonth() + step);

        this._buildCalendar();

    },

    _onChoose : function(date) {

        this.val(date);
        this._getCalendarPopup().hide();
        this.trigger('choose', this.parseDate(date));

    },

    getCalendar : function(month) {

        var weekDay,
            weeks = [],
            week = new Array(7),
            dateIterator = new Date(month.getTime());

        for(dateIterator.setDate(1); dateIterator.getMonth() == month.getMonth(); dateIterator.setDate(dateIterator.getDate() + 1)) {
            weekDay = (dateIterator.getDay() + 6) % 7; // Получаем 0 - пн, 1 - вт, и т.д.

            week[weekDay] = new Date(dateIterator.getTime());

            if(weekDay == 6) {
                weeks.push(week);
                week = new Array(7);
            }
        }

        if(weekDay != 6)
            weeks.push(week);

        while(weeks.length < 6)
            weeks.push([,,,,,,]);

        return weeks;

    },

    setLimits : function(earlier, later) {

        this.earlierLimit = earlier;
        this.laterLimit = later;

        var value = this.parseDate(this.val());

        if(value && !this._isValidDate(value))
            this.val('');

        if(earlier && compareMonths(this._month, earlier) < 0)
            this._month = new Date(earlier.getTime());

        if(later && compareMonths(later, this._month) < 0)
            this._month = new Date(later.getTime());

        this._month.setDate(1);
    },

    _isValidDate : function(day) {

        return !(this.earlierLimit && day < this.earlierLimit || this.laterLimit && day > this.laterLimit);

    },

    _buildCalendar : function() {

        var _this = this;

        var month = _this._month,
            calendar,
            row,
            rows = [],
            content,
            prevMonth = !_this.earlierLimit || compareMonths(month, _this.earlierLimit) > 0,
            nextMonth = !_this.laterLimit || compareMonths(_this.laterLimit, month) > 0,
            arrows;

        row = [];

        $.each(DAYNAMES, function(i, name) {
            var dayname = {
                elem : 'dayname',
                tag : 'th',
                content : name
            };

            if(i > 4)
                dayname.mods = {
                    type : 'weekend'
                };

            row.push(dayname);
        });

        rows.push(row);

        $.each(_this.getCalendar(month), function(i, week) {
            row = [];

            $.each(week, function(i, day) {
                var off = !_this._isValidDate(day),
                    weekend = i > 4,
                    dayElem,
                    today,
                    type,
                    state;

                dayElem = {
                    elem : 'day',
                    tag : 'td',
                    content : {
                        block : 'b-link',
                        url : '#',
                        content : day ? day.getDate() : '&nbsp;'
                    }
                };

                if(day && !off)
                    dayElem.attrs = {
                        'data-day' : day.getDate() + '.' + (day.getMonth() + 1) + '.' + day.getFullYear()
                    };

                if(off || weekend)
                    type = weekend ? (off ? 'weekend-off' : 'weekend') : 'off';

                if(day && _this._selected && day.getTime() == _this._selected.getTime())
                    state = 'current';

                if(day && !state &&
                   day.getDate() == _this.today.getDate() &&
                   day.getMonth() == _this.today.getMonth() &&
                   day.getYear() == _this.today.getYear()) {
                    state = 'mark';
                }

                if(today || type || state) {
                    dayElem.mods = {};

                    if(today)
                        dayElem.mods.today = 'yes';

                    if(type)
                        dayElem.mods.type = type;

                    if(state)
                        dayElem.mods.state = state;
                }

                row.push(dayElem);
            });

            rows.push(row);
        });

        content = [];

        $.each(rows, function(i, row) {
            content.push({
                elem: 'row',
                tag: 'tr',
                content: row
            });
        });

        calendar = $(HTML.build({
            block : 'b-ext-calendar',
            content : {
                attrs : { 'class' : 'b-ext-calendar-i' },
                content : [
                    {
                        elem : 'name',
                        content : BEM.I18N('b-form-input', 'departure-date')
                    },
                    {
                        elem: 'title',
                        content: [
                            {
                                elem : 'arrow',
                                content: {
                                    block : 'b-link',
                                    url : '#',
                                    content: {
                                        block : 'b-icon',
                                        mods : { type : 'left' }
                                    }
                                }
                            },
                            {
                                elem : 'arrow',
                                content: {
                                    block : 'b-link',
                                    url : '#',
                                    content: {
                                        block : 'b-icon',
                                        mods : { type : 'right' }
                                    }
                                }
                            },
                            MONTHNAMES[month.getMonth()] + ' ' + month.getFullYear()
                        ]
                    },
                    {
                        elem : 'layout',
                        tag : 'table',
                        attrs : { cellspacing : '0' },
                        content : content
                    }
                ]
            }
        })).bem('b-ext-calendar');

        arrows = calendar.elem('arrow');

        if(prevMonth)
            this.findBlockInside(arrows.eq(0), 'b-link').bindTo('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                _this.switchMonth(-1);
            });
        else
            calendar.setMod(arrows.eq(0), 'disabled', 'yes');

        if(nextMonth)
            this.findBlockInside(arrows.eq(1), 'b-link').bindTo('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                _this.switchMonth(1);
            });
        else
            calendar.setMod(arrows.eq(1), 'disabled', 'yes');

        calendar.bindTo('day', 'click', function(e) {
            e.preventDefault();
            e.stopPropagation();

            var date = e.data.domElem.attr('data-day');

            if(date)
                _this._onChoose(date);
        });

        _this._getCalendarPopup().setContent(calendar.domElem);

        return calendar;
    },

    parseDate: function(val) {

        function parseDateParts(str) {
            var match;

            match = /^\s*(\d{1,2})[./-](\d{1,2})(?:[./-](\d{4}|\d\d))?\s*$/.exec(str);

            if(match) {
                return [match[1], match[2] - 1, match[3]];
            }

            match = /^\s*(\d{4})[./-](\d\d)(?:[./-](\d\d))?\s*$/.exec(str);

            if(match) {
                return [match[3], match[2] - 1, match[1]];
            }

            // закоментировала ибо у нас локализованные названия месяцев
            /* match = /^\s*(\d{1,2})\s+(янв|фев|мар|апр|ма[йя]|июн|июл|авг|сен|окт|ноя|дек)/i.exec(str);

            if(match) {
                var day = match[1];

                for(var i = 0; i < 12; i++) {
                    if(MONTHNAMES[i].substr(0, 3).toLowerCase() == match[2].toLowerCase() ||
                       MONTHNAMESINFLECTED[i].substr(0, 3).toLowerCase() == match[2].toLowerCase()) {
                        return [day, i];
                    }
                }
            } */

            return null;
        }

        var parsed = parseDateParts(val);

        if(parsed) {
            var day = parsed[0],
                month = parsed[1],
                year = parsed[2],
                date = new Date(this.today.getTime());

            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            date.setMilliseconds(0);

            date.setMonth(month, day);

            if(year)
                date.setFullYear(year);

            return date;
        }

        return null;

    }
}, {
    live : function() {

        this.__base.apply(this, arguments);
        this.liveBindTo('calendar', 'leftclick', function() {
            this._toggleCalendar();
        });

        return false;

    }
});

})();
