(function() {

BEM.DOM.decl({ name : 'b-form', modName : 'type', modVal : 'ucus-order' }, {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            this.pricetable = this.findBlockInside('b-pricetable');
            this.buy_button = this.findBlockInside('b-pricetable-summ');

            this.adults = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'adults' });
            this.children = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'children' });
            this.infants = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'infants' });

            this.choice = this.domElem.find('input[name=choice]');

            this.inputs = {
                'adults': this.domElem.find('input[name=n_adult]'),
                'children': this.domElem.find('input[name=n_child]'),
                'infants': this.domElem.find('input[name=n_infant]')
            };

            if(!this.inputs.adults.val())
                this.inputs.adults.val(1);

            this._handleSeatsDropdown('adults');
            this._handleSeatsDropdown('children');
            this._handleSeatsDropdown('infants');

            this._updateCatSwitchers();

            this.bindTo('submit', this._onSubmit);

        }

    },

    _handleSeatsDropdown : function(cat) {
        var _this = this,
            dropdown = this[cat];

        if(!dropdown)
            return;

        $.each(this.findBlocksInside(dropdown.elem('popup'), 'b-link'), function() {

            this.on('click', function(e) {

                var n = this.params.value;

                dropdown.getPopup().hide();

                dropdown.findBlockInside('switcher', 'b-link').domElem.html(e.block.domElem.html());

                _this.inputs[cat].val(n);

                _this._updateCatSwitchers();

                _this.pricetable.onQuantityChange(_this.getQuantities());
            });

        });

    },

    _updateCatSwitchers: function() {
        // RASP-12701 Ограничивать максимальное количество пассажиров для Biletall
        var maxSeats = 4,
            _this = this;

        var adultsNumber = this._getValue('adults'),
            childrenNumber = this._getValue('children'),
            infantsNumber = this._getValue('infants'),
            selectedSeats = adultsNumber + childrenNumber,
            possibleSeats = maxSeats - selectedSeats;

        this._updateCatMenuItems('adults', possibleSeats, maxSeats);
        this._updateCatMenuItems('children', possibleSeats, maxSeats);
        this._updateCatMenuItems('infants', maxSeats, adultsNumber); // Не менее одно взрослого на каждого младенца

        if (adultsNumber < infantsNumber) {
            this.inputs.infants.val(0);

            var items = this.findBlocksInside(this.infants.elem('popup'), 'b-link')
            this.infants.findBlockInside('switcher', 'b-link').domElem.html(items[0].domElem.html());
        }
    },

    _updateCatMenuItems: function(cat, possibleSeats, maxSeats, withNone) {
        var _this = this,
            dropdown = this[cat],
            value = this._getValue(cat),
            maxPossibleSeat = Math.min(value + possibleSeats, maxSeats);

        $.each(this.findBlocksInside(dropdown.elem('popup'), 'b-menu__layout-vert-cell'), function() {
            var link = _this.findBlockInside(this.domElem, 'b-link');
            $(this.domElem).css("display", maxPossibleSeat >= link.params.value ? "block" : "none");
        });
    },

    _getValue: function(cat) {
        return parseInt(this.inputs[cat].val()) || 0;
    },

    getQuantities: function() {

        var q = {};

        $.each(this.inputs, function(cat, input) {
            q[cat] = parseInt(input.val()) || 0;
        });

        return q;

    },

    _onSubmit : function(e) {
        var choice = this.pricetable.getRadioChoice().val();
        $(this.choice).val(choice);

//        e.preventDefault();
//        yaCounter99704.hit($.parseQuery($('.b-pricetable__radio:checked').val()).partner + '_click');
//        addCounter(168, 2190);
//        var form = this.domElem;
//        setTimeout(function() {form.submit()}, 1000);

    }

});

})();
