BEM.DOM.decl({ name: 'b-map', modName: 'type', modVal: 'airplanes' }, {

    onSetMod: {
        'js': function() {
            var _this = this,
                i = 0;

            // RASP-3245, растягиваем карту вниз
            if(!this.hasMod('size', 'big')) {
                var $map = $(this.domElem),
                    mapExtendedHeight = $(window).height() - $map.offset().top;
                if(mapExtendedHeight > $map.height()) {
                    $map.height(mapExtendedHeight);
                }
            }

            this.map = null;
            this.mediaUrl = BEM.blocks['i-global'].param('static-host');
            this.roadLine = null;
            this.delay = 2 * 1000;
            this.colorCount = 4;
            this.airTimeout = null;
            this.firstOpenPlaneI = -1;

            // Соответствие массиву данных
            this.iTrack = i++;
            this.iRouteNumber = i++;
            this.iRouteNumberEng = i++;
            this.iRouteTitle = i++;
            this.iUrl = i++;
            this.iRouteCompany = i++;
            this.iTType = i++;

            this.iLngAir = i++;
            this.iLatAir = i++;
            this.iLngFrom = i++;
            this.iLatFrom = i++;
            this.iLngTo = i++;
            this.iLatTo = i++;
            this.iPlacemark = i++;
            this.iTimeFrom = i++;
            this.iTimeTo = i++;
            this.iAlpha = i++;
            this.iScale = i++;
            this.iColor = i++;
            this.iObserver = i++;
            
            this.selectedIndex = 0;
            this.selectedUid = 0;

            this.dataUrl = '/flights_in_air/';
//            this.dataUrl = 'http://rasp.yandex.ru/flights_in_air/';

            this.boundsTimeout = null;
            this.routes = [];

            this.filters = {};
            this.eventHandler = $('<div>voila</div>');

        }
    },

    init: function(options, setHashMapParams) {
        var _this = this;

        ymaps.ready(function() {

            _this.map = new ymaps.Map("b-map", {
                center: options.center,
                zoom: options.zoom,
                behaviors: ["default", "scrollZoom"]
            });

            _this.map.controls
                .add("zoomControl")
                .add(new ymaps.control.TypeSelector())
                .add("mapTools")
                .add("scaleLine");

            _this.eventHandler.trigger('map-ready');

            _this.map.events.add('boundschange', function (event) {
                clearTimeout(_this.boundsTimeout);
                _this.boundsTimeout = setTimeout(function() {
                    _this.onBoundsChange();
                }, 1000);
            });

            _this.map.events.add('click', function (event) {
                _this.hideRoute();
            });

            _this.planeCollection = new ymaps.GeoObjectCollection({}, {});

            _this.createAirIcons();

            setHashMapParams(_this.map);
        });

    },

    setMyGeoPoint: function(lng, lat) {
        this.myGeoPoint = [lng, lat];
        return this.myGeoPoint;
    },

    str2bin: function(str) {
        var res = 0;
        for (var i = 0; i < str.length; i ++) {
            res += str.charCodeAt(i);
        }
        return res;
    },

    hideTrack: function() {
        if(this.roadLine) {
            this.map.geoObjects.remove(this.roadLine);
            this.roadLine = null;
        }
    },

    iconStyle: function(route) {
        return (route[this.iTType] == 2 ? 'plane' : 'heli') + "#" + route[this.iColor] + "-" + route[this.iAlpha] + "customPoint";
    },

    setIcon: function(route, color) {
        if(color !== undefined)
            route[this.iColor] = color;

        route[this.iPlacemark].options.set('preset', this.iconStyle(route));
    },

    showRoute: function(i) {
        this.hideTrack();

        if (this.selectedIndex !== undefined) {
            this.setIcon(this.routes[i], this.str2bin(this.routes[i][this.iRouteNumber]) % this.colorCount + 1);
        }

        var _this = this,
            plList = new Array(),
            roadtrack = this.routes[i][this.iTrack],
            d,
            dSteps = 50,
            resL;

        plList.push([roadtrack[0][0], roadtrack[0][1]]);
        for (var k = 0; k < roadtrack.length - 1; k++) {
            for (d = 1; d <= dSteps; d++) {
                resL = this.calcGreateCircleIntermidiatePoint(roadtrack[k][0], roadtrack[k][1], roadtrack[k + 1][0], roadtrack[k + 1][1], d / dSteps);
                plList.push([resL[0], resL[1]]);
            }
        }

        this.roadLine = new ymaps.Polyline(plList, {}, {preset: "plane#CustomLine"});
        this.map.geoObjects.add(this.roadLine);

        $.each(this.routes || [], function(j, route) {
            if ((route[_this.iPlacemark] != null) && (i != j)) {
                _this.setIcon(route, 0);
            }
        });

        this.selectedIndex = i;
        this.selectedUid = this.routes[i][this.iRouteNumberEng];
        this.showRouteInfo(i, this.getMyTime());
    },

    hideRoute: function() {

        this.hideTrack();

        var _this = this,
            i = this.selectedIndex;

        $.each(this.routes || [], function(j, route) {
            if((route[_this.iPlacemark] != null) && (i != j)) {
                _this.setIcon(route, _this.str2bin(route[_this.iRouteNumber]) % _this.colorCount + 1);
            }
        });

        this.showRouteInfo(i);
        this.selectedIndex = undefined;
        this.selectedUid = undefined;
    },

    setRouteInfoCallback: function(fn) {
        this.routeInfoCallback = fn;
    },

    showRouteInfo: function(i, ct) {
        if(ct === undefined) {
            if(this.routeInfoCallback) {
                this.routeInfoCallback();
            } else {
                if(i !== undefined && this.routes[i] && this.routes[i][this.iPlacemark])
                    this.map.balloon.close();
            }

            return;
        }

        var route = this.routes[i],
            track = route[this.iTrack],
            trackLen = track.length,
            left = Math.round((this.routes[i][this.iTrack][trackLen - 1][2] - ct)),
            distance = this.calcGeoDistance(track[0][0], track[0][1], track[trackLen - 1][0], track[trackLen - 1][1]),
            pm,
            content;

        if(this.routeInfoCallback) {
            this.routeInfoCallback({
                distance: distance,
                number: route[this.iRouteNumber],
                title: route[this.iRouteTitle],
                url: route[this.iUrl],
                arrivalIn: left
            });
        } else {
            pm = this.routes[i][this.iPlacemark];
            content = '<div>' +
                '<strong>' + route[this.iRouteTitle] + '</strong><br />' +
                '<a href="' + route[this.iUrl] + '">' + BEM.I18N('b-maps-search', 'route', { 'route-number': route[this.iRouteNumber] }) + '</a><br />' +
                BEM.I18N('b-maps-search', 'distance', { distance: Math.floor(distance) }) + '<br />' +
                (left > 0 ? BEM.I18N('b-maps-search', 'arrival-in', { 'time-left': BEM.blocks['i-time'].humanDuration(left) }) : BEM.I18N('b-maps-search', 'arrived')) +
                '</div>';
            this.map.balloon.open(
                pm.geometry.getCoordinates(),
                {contentBody: content},
                {closeButton: false}
            );
        }
    },

    calcGreateCircleIntermidiatePoint: function(lon1, lat1, lon2, lat2, f) {
        lon1 = lon1 * 3.1415 / 180;
        lat1 = lat1 * 3.1415 / 180;
        lon2 = lon2 * 3.1415 / 180;
        lat2 = lat2 * 3.1415 / 180;
        var d = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
        var A = Math.sin((1 - f) * d) / Math.sin(d);
        var B = Math.sin(f * d) / Math.sin(d);
        var x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
        var y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
        var z = A * Math.sin(lat1) + B * Math.sin(lat2);
        var lat = Math.atan2(z, Math.sqrt(x * x + y * y)) * 180 / 3.1415;
        var lon = Math.atan2(y, x) * 180 / 3.1415;
        return [lon, lat];
    },

    calcGeoDistance: function(lon1, lat1, lon2, lat2) {
        lon1 = lon1 * Math.PI / 180;
        lat1 = lat1 * Math.PI / 180;
        lon2 = lon2 * Math.PI / 180;
        lat2 = lat2 * Math.PI / 180;
        var d = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
        return d * 6371;
    },

    isInAir: function(route, timestamp) {
        var track = route[this.iTrack];

        // точек может быть несколько, берем первую и последнюю
        return (track[0][2] <= timestamp) && (timestamp < track[track.length - 1][2]);
    },

    searchTrackPart: function(i, ct) {
        var track = this.routes[i][this.iTrack],
            k;

        for (k = 0; k < track.length - 1; k++) {
            if ((track[k][2] <= ct) && (ct < track[k + 1][2])) {
                return k;
            }
        }
        return -1;
    },

    // преобразует географические координаты в пиксельные
    coordinate2MapPixels: function(point) {
        var projection = this.map.options.get('projection');
        return this.map.converter.globalToPage(
            projection.toGlobalPixels(
                point,
                this.map.getZoom()
            )
        );
    },

    calcTrackPosition: function(i, ct) {
        var trackNum = this.searchTrackPart(i, ct);
        if (trackNum >= 0) {
            var roadtrack = this.routes[i][this.iTrack];

            var x = (ct - roadtrack[trackNum][2]) / (roadtrack[trackNum + 1][2] - roadtrack[trackNum][2]);
            var dt = 10;
            var res = this.calcGreateCircleIntermidiatePoint(roadtrack[trackNum][0], roadtrack[trackNum][1], roadtrack[trackNum + 1][0], roadtrack[trackNum + 1][1], x);

            var xPrev = ((ct - dt) - roadtrack[trackNum][2]) / (roadtrack[trackNum + 1][2] - roadtrack[trackNum][2]);
            var resPrev = this.calcGreateCircleIntermidiatePoint(roadtrack[trackNum][0], roadtrack[trackNum][1], roadtrack[trackNum + 1][0], roadtrack[trackNum + 1][1], xPrev);
            var pointFrom = this.coordinate2MapPixels(this.setMyGeoPoint(resPrev[0], resPrev[1]));
            var pointTo = this.coordinate2MapPixels(this.setMyGeoPoint(res[0], res[1]));
            var alpha = 180 * Math.atan2(pointTo[0] - pointFrom[0], pointTo[1] - pointFrom[1]) / 3.1415;
            alpha = (Math.round(alpha / 15) * 15 + 270) % 360;
            this.routes[i][this.iAlpha] = alpha;
            this.routes[i][this.iLngAir] = res[0];
            this.routes[i][this.iLatAir] = res[1];
        }
    },

    getMyTime: function() {
        return Math.round(new Date().getTime() / 1000 + window.timeCorrection);
    },

    getCurrentDelay: function() {
        return this.delay * Math.pow(1.41, (10 - this.map.getZoom()));
    },

    onBoundsChange: function() {
        BEM.channel('b-map_type_airplanes').trigger('bounds-change', this.map);
        this.loadAndDrawPlanes(this.map.getBounds());
    },

    /*
     * Определение начальных границ и показ самолётиков
     */
    filter: function(newFilters, search, callback) {
        var _this = this;
        this.filters = newFilters;

        this.hideRoute();

        $.getJSON(this.dataUrl + 'bounds?callback=?', this.filters, function (data) {
            var bounds = [[data.left, data.bottom], [data.right, data.top]];

            if(typeof callback == 'function') {
                callback(data.count);
            }

            if(data.count) {

                _this.callWhenMapReady(function() {
                    (function(__this) {
                        var map = __this.map,
                            mapBounds = map.getBounds();
                        if(search) {
                            // Если это был поиск, то центрируем карту по результатам
                            if(Math.min(Math.abs(bounds[0][0] - bounds[1][0]), Math.abs(bounds[0][1] - bounds[1][1])) < 8) {
                                bounds[0][0] -= 10;
                                bounds[0][1] -= 10;
                                bounds[1][0] += 10;
                                bounds[1][1] += 10;
                            }
                            map.setBounds(bounds, {precizeZoom: true, checkZoomRange: true});
                        } else {
                            // Иначе перемещаем только если результаты не попадают во вьюпорт
                            if((mapBounds[1][0] < bounds[0][0] || bounds[1][0] < mapBounds[0][0]) ||
                                (mapBounds[1][1] < bounds[0][1] || bounds[1][1] < mapBounds[0][1]))
                            {
                                bounds = [[Math.min(mapBounds[0][0], bounds[0][0]), Math.min(mapBounds[0][1], bounds[0][1])], [Math.max(mapBounds[1][0], bounds[1][0]), Math.max(mapBounds[1][1], bounds[1][1])]];
                                if(Math.min(Math.abs(bounds[0][0] - bounds[1][0]), Math.abs(bounds[0][1] - bounds[1][1])) < 8) {
                                    bounds[0][0] -= 10;
                                    bounds[0][1] -= 10;
                                    bounds[1][0] += 10;
                                    bounds[1][1] += 10;
                                }
                                map.setBounds(bounds, {precizeZoom: true, checkZoomRange: true});
                            }
                        }
                        if(map.getZoom() < 3) {
                            map.setZoom(3);
                        }
                        clearTimeout(_this.boundsTimeout);
                    })(_this);
                });

            }


            _this.callWhenMapReady(function() {_this.loadAndDrawPlanes(bounds);});
        });

    },

    loadAndDrawPlanes: function() {
        var _this = this,
            params = this.viewportParams(this.filters);

        $.getJSON(this.dataUrl + 'flights?callback=?', params, function(data) {
            if(data) {
                _this.show(data);
            }
        });
    },

    show: function(data) {

        this.routes = data;
        this.map.geoObjects.remove(this.planeCollection);
        this.planeCollection.removeAll();

        this.selectedIndex = undefined;

        this.drawPlanes(true);

        // сначала добавляем все в менеджер, потом его показываем
        this.map.geoObjects.add(this.planeCollection);

        // Показываем информацию ранее выбранного рейса
        if(this.selectedUid !== undefined) {
            for(var i = 0, l = this.routes.length; i < l; i++) {
                var route = this.routes[i];
                if (route[this.iPlacemark] != null && (route[this.iRouteNumberEng] == this.selectedUid)) {
                    this.showRoute(i);
                }
            }
        }

    },

    getMyTime: function() {
        return Math.round(new Date().getTime() / 1000 + window.timeCorrection);
    },

    drawPlanes: function(runNext) {
        runNext = typeof runNext != 'boolean' ? true : runNext;

        var _this = this,
            ct = this.getMyTime(),
            oldAlpha = new Array();

        $.each(this.routes || [], function(i, route) {
            oldAlpha[i] = route[_this.iAlpha];
        });

        $.each(this.routes || [], function(i, route) {
            var point;

            if(route[_this.iPlacemark] != null) {
                _this.calcTrackPosition(i, ct);

                if(_this.isInAir(route, ct)) {
                    point = _this.setMyGeoPoint(route[_this.iLngAir], route[_this.iLatAir]);
                    route[_this.iPlacemark].geometry.setCoordinates(point);
                    if(oldAlpha[i] != route[this.iAlpha]) {
                        _this.setIcon(route);
                    }
                } else {
                    _this.planeCollection.remove(route[_this.iPlacemark]);
                }
            } else {
                if(_this.isInAir(_this.routes[i], ct)) {
                    _this.addRoadToMap(i, ct);
                }
            }

            if(_this.selectedIndex == i) {
                _this.showRouteInfo(i, ct);
            }
        });

        if(runNext) {
            this.airTimeout = setTimeout((function(self) {
                return function() { self.drawPlanes(runNext); };
            })(this), this.getCurrentDelay());
        }

    },

    addRoadToMap: function(i, ct) {
        var _this = this,
            route = this.routes[i];

        route[this.iColor] = this.str2bin(route[this.iRouteNumber]) % this.colorCount + 1;

        this.calcTrackPosition(i, ct - 60); // ЩИТО?
        this.calcTrackPosition(i, ct);

        var position = [route[this.iLngAir], route[this.iLatAir]],
            properties = {
//                    hintContent: 'hintContent',
//                    balloonContent: 'balloon html'
            },
            options = {
                draggable: false,
                hideIconOnBalloonOpen: false,
//                balloonCloseButton: false,
                preset: this.iconStyle(route)
            },
            placemark = new ymaps.Placemark(
                position,
                properties,
                options
            );

        if (i == this.firstOpenPlaneI) {
            route[this.iScale] = 0;
        }

        this.planeCollection.add(placemark);

        placemark.events.add('click', function(e) {
            _this.showRoute(i);
        });

        route[this.iPlacemark] = placemark;
    },

    callWhenMapReady: function(callback) {
        if(this.map) {
            callback();
        } else {
            this.eventHandler.on('map-ready', callback);
        }
    },

    viewportParams: function(filters) {
        if(this.map) {
            var bounds = this.map.getBounds(),
                center = [(bounds[1][0] + bounds[0][0]) / 2, (bounds[1][1] + bounds[0][1]) / 2],
                width = Math.abs(bounds[0][0] - bounds[1][0]),
                height = Math.abs(bounds[0][1] - bounds[1][1]);

            return $.extend({}, filters || {}, {
                center: '' + center[0] + ',' + center[1],
                span: '' + width + ',' + height,
                zoom: this.map.getZoom()
            });
        } else {
            return filters;
        }
    },

    createAirIcons: function() {
        var alpha,
            xpos,
            j,
            preset;

        for(alpha = 0; alpha < 360; alpha = alpha + 15) {
            xpos = Math.floor(alpha / 15);
            j;
            for(j = 0; j <= this.colorCount; j++) {
                this.createIconStyle(alpha, j, xpos, 'plane', 'a');
                this.createIconStyle(alpha, j, xpos, 'heli', 'h');
            }
        }

        preset = {
            strokeColor: '#FF0000',
            strokeWidth: 3
        };

        ymaps.option.presetStorage.add("plane#CustomLine", preset);
    },

    createIconStyle: function(alpha, j, xpos, name, img) {

        var preset = {
            iconImageHref: this.mediaUrl + 'i/maps/air/' + img + '_' + xpos + '_' + j + '.png',
            iconImageOffset: [-20, -20],
            iconImageSize: [55, 55]
        };

        ymaps.option.presetStorage.add(name + "#" + j + "-" + alpha + "customPoint", preset);
    }

});
