include('../../../../attic/js/yaUtils.js');

BEM.DOM.decl({ name: 'b-maps-search', modName: 'type', modVal: 'trains' }, {

    onSetMod: {
        'js': function() {
            var _this = this,
                initial = yaUtils.getHashParams();

            if(initial.center) {
                initial.center = $.map(initial.center.split(','), parseFloat);
            } else {
                initial.center = this.params.center;
            }

            if(initial.zoom) {
                initial.zoom = parseFloat(initial.zoom);
            } else {
                initial.zoom = this.params.zoom;
            }

            this.bindTo('submit', function(e) { _this._onSubmit(e); });

            this.trains = this.findBlockOutside('b-page').findBlockInside({ blockName : 'b-map', modName : 'type', modVal : 'trains' });
            this.inputs = {
                'number': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'number' }),
                'type': this.findBlockInside({ blockName : 'b-form-select', modName : 'mod', modVal : 'type' }),
                'station': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'station' }),
                'city': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'city' })
            };

            $.each(this.inputs, function(key, elem) {
                if (elem) {
                    elem.val(initial[key] || '');
                }
            });

            BEM.channel('b-map_type_trains').on('info', function(e, data) {
                if(_this.showInfo(data.info)) {
                    data.handled = true;
                }
            });

            var setHashMapParams = function(map) {
                var center = map.getCenter();
                yaUtils.setHashParams({
                    center: center[0] + ',' + center[1],
                    zoom: map.getZoom()
                });
            };

            BEM.channel('b-map_type_trains').on('bounds-change', function(e, map) {
                setHashMapParams(map);
            });

            this.desc = this.findBlockOutside('b-page').findBlockInside('b-maps-air-desc');

            this.trains.init(initial, setHashMapParams);

            this.filter();

        }
    },

    showInfo: function(info) {
        if(!this.desc) {
            return;
        }
        if(info == 'spinner') {
            this.desc.domElem.html(
                '<div class="b-maps-search_type_trains-desc__item"><strong><img src="http://lego.static.yandex.net/2.1/common/block/b-spin/_size/b-spin_16.gif" /></div>'
            ).removeClass('i-hidden');
        } else if(info) {
            var title = info.title.replace(' - ', '&nbsp;&mdash; '), // RASP-13580 Поправить блок описания рейса на карте паровозиков
                html = ('<div class="b-maps-air-desc__item"><strong>' + title + '</strong></div>' +
                '<div class="b-maps-air-desc__item"><a target=_blank href="' + info.url + '">' + BEM.I18N('b-maps-search', 'train', { 'train-number': info.number }) + '</a></div>');

            if (info.left > 0) {
                html = html + '<div class="b-maps-air-desc__item">' + BEM.I18N('b-maps-search', 'arrival-in-train', { 'time-left': BEM.blocks['i-time'].humanDuration(info.left) }) + '</div>';
            }

            this.desc.domElem.html(html).removeClass('i-hidden');
        } else {
            this.desc.domElem.addClass('i-hidden');
        }
        return true;
    },

    _onSubmit: function(e) {

        e.preventDefault();
        var filters = this.filter(true);
        yaUtils.setHashParams(filters);

    },

    filter: function (search) {
        var _this = this,
            filters = {};

        $.each(this.inputs, function(key, elem) {
            if (elem) {
                filters[key] = elem.val()
            }
        });

        this.trains.filter(filters, search, function(count) {
            if(count) {
                _this.findBlockOutside('b-page').elem('not-found').addClass('i-hidden');
            } else {
                _this.findBlockOutside('b-page').elem('not-found').removeClass('i-hidden');
            }
        });

        return filters;
    }

});
