<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-popup/lego:field[@lego:type = 'label-new']" mode="lego:content">
    <label class="{lego:name(.)}__label">
        Имя (не более 15 символов):
        <input class="{lego:name(.)}__input" type="text" onkeyup="$(this).parent().next().find('.{lego:name(.)}__colors__value').eq(1).find('.b-label').text(($(this).val() == '' ? '&#0160;&#0160;' : $(this).val()));" />
        <xsl:call-template name="lego:apply">
            <xsl:with-param name="content">
                <lego:b-notification lego:type="error">
                    <lego:b-mail-icon lego:type="error" alt="[!]"/>
                    <lego:html>Это поле необходимо заполнить.</lego:html>
                </lego:b-notification>
            </xsl:with-param>
        </xsl:call-template>
    </label>

    <table class="{lego:name(.)}__colors">
        <tr>
            <td class="{lego:name(.)}__colors__label {lego:name(.)}__colors__label_color">Цвет:</td>
            <td class="{lego:name(.)}__colors__value">
                <xsl:apply-templates/>
            </td>
        </tr>
        <tr>
            <td class="{lego:name(.)}__colors__label">Вид:</td>
            <td class="{lego:name(.)}__colors__value">
                <xsl:call-template name="lego:apply">
                    <xsl:with-param name="content">
                        <lego:b-label lego:type="rounded" lego:disabled="sample" color="#8867c9">  </lego:b-label>
                    </xsl:with-param>
                </xsl:call-template>
            </td>
        </tr>
    </table>

</xsl:template>

</xsl:stylesheet>