(function() {

BEM.DOM.decl('b-preview-train-big', {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            var row = this.domElem.closest(BEM.DOM.blocks['b-pricetable'].buildSelector('row')),
                mainRow = row.prev(),
                thumbs;

            this.form = this.findBlockOutside('b-form');

            this.rulesData = this.findBlockOutside('b-pricetable').elemParams(mainRow)['rules-data'];

            this._thumb = this.findBlockInside(mainRow, 'b-preview-train');

            if(this._thumb) {

                thumbs = this._thumb.findElem('place');

                this.findElem('seat').each(function(i) {
                    $(this).data('thumb', thumbs.eq(i));
                });

            }

            this._freeSeats = this.findElem(this.elem('container'), 'seat', 'state', 'white');

            this.on('seatsChange', this._onSeatsChange);

            this.on('sexChange', this._onSexChange);

            this.on('show', function(e) {
                this.selectSeat(this.findElem('seat', 'state', 'selected').eq(0));
            });

        }

    },

    selectSeats: function(index) {

        var _this = this,
            position = index,
            occupied,
            free = this._freeSeats,
            q = this.form.getQuantities(),
            selected,
            numbers,
            data = this.form.getData();

        this.setMod(free, 'state', 'white');

        // Пока отключаем специальный режим
        if(false && this.form.params['partner-code'] == 'ufs' && this.rulesData['класс'] == 'МЯГК') {

            if(
                this.rulesData['перевозчик'] == 'ФПК'
                && $.inArray(this.rulesData['класс обслуживания'], ['1А', '1М']) != -1
            ||
                this.rulesData['перевозчик'] == 'ГРАНД'
                && $.inArray(this.rulesData['класс обслуживания'], ['1А', '1И', '1М']) != -1
            ) {
                occupied = q.adults;
            } else {
                occupied = q.adults + q.children;
            }

            if(occupied > free.length) {
                this.form.summ.showError(BEM.I18N('b-form', 'order-insufficient-seats-amount'));
                return;
            }

            var cell = 2,
                shift = position % cell,
                mod = occupied % cell;

            position -= shift;

            if(mod)
                occupied += cell - mod;

            if(position + occupied > free.length)
                position = Math.max(free.length - occupied, 0);

            selected = this._freeSeats.slice(position, position + occupied);

            this.setMod(selected, 'state', 'selected');

            numbers = $.makeArray(selected.map(function() { return _this.elemParams($(this)); }));

            var coupes = numbers.length / cell;

            this.form.setTotal(data, {
                numbers: numbers,
                description_key: 'order-coupes-description-dynamic', //'Цена за ' +  coupes + ' купе, места № ' + numbers.join(', '),
                total: data.tariff * coupes,
                coupes: coupes
            });

        } else {

            occupied = q.adults + q.children;

            if(occupied > free.length) {
                this.form.summ.showError(BEM.I18N('b-form', 'order-insufficient-seats-amount'));
                return;
            }

            if(position + occupied > free.length)
                position = Math.max(free.length - occupied, 0);

            selected = free.slice(position, position + occupied);

            this.setMod(selected, 'state', 'selected');

            numbers = $.makeArray(selected.map(function() { return _this.elemParams($(this)); }));

            if(numbers.length)
                this.form.setTotal(data, { numbers: numbers });

        }

    },

    selectSeat : function(seat, skipInvalid) {

        var _this = this,
            index = $.inArray(seat[0], this._freeSeats),
            free = this._freeSeats,
            selected,
            numbers;

        if(index < 0 && skipInvalid) {
            return;
        }

        if(!this.form.checkQuantities())
            return;

        this.selectSeats(index);

    },

    _onSeatsChange : function(e) {

        this.selectSeat(this.findElem('seat', 'state', 'selected').eq(0));

    },

    _onSexChange : function(e, sex) {

        var _this = this,
            allSeats = this.findElem(this.elem('container'), 'seat')
                           .not(this.buildSelector('seat', 'state', 'busy')),
            selected = this.findElem('seat', 'state', 'selected').eq(0),
            available,
            seats = this.params;

        this.setMod(this._freeSeats, 'state', 'white');

        if(sex == 'any') {
            available = seats.mixed.concat(seats.sex);
        } else if(sex == 'male') {
            available = seats.male.concat(seats.sex);
        } else if(sex == 'female') {
            available = seats.female.concat(seats.sex);
        } else if(sex == 'mixed') {
            available = seats.mixed.concat(seats.sex);
        } else {
            throw 'Unknown sex ' + sex;
        }

        this._freeSeats = $();

        allSeats.each(function() {

            var number = _this.elemParams($(this));

            if($.inArray(number, available) != -1) {

                _this._freeSeats.push(this);

                if(_this._thumb)
                    _this._thumb.setMod($(this).data('thumb'), 'state', 'white');

            } else {

                _this.setMod($(this), 'state', 'deny');

                if(_this._thumb)
                    _this._thumb.setMod($(this).data('thumb'), 'state', 'busy');

            }

        });

        this.setMod(this._freeSeats, 'state', 'white');

        this.selectSeat(selected);

    }

}, {

    live : function() {

        this.liveBindTo('seat', 'click', function(e) {

            e.stopPropagation();

            this.selectSeat(e.data.domElem, true);

        });

    }

});

})();
