(function() {

BEM.DOM.decl('b-pricetable-summ', {

    clear: function() {

        this.elem('placedesc', 'type', 'error').addClass('i-hidden');

        this.elem('placedesc').addClass('i-hidden');
        this.elem('cell', 'type', 'summ').empty();

        this.findBlockInside('b-form-button').domElem.removeClass('i-hidden');

    },

    showTotal: function(description, total, currency, from) {

        this.elem('placedesc', 'type', 'error').addClass('i-hidden');

        this.findBlockInside('b-form-button').domElem.removeClass('i-hidden');

        this.elem('placedesc', 'type', 'desc').removeClass('i-hidden');
        this.elem('placedesc-details').html(description);

        var params = {
            value : total,
            currency: currency,
            from: from,
            cents : true,
            unit : '<span class="b-pricetable__unit">$1</span>',
            whole : '<span class="b-pricetable__whole-part-price">$1</span>'
        };

        BEM.DOM.update(this.elem('cell', 'type', 'summ'), BEMHTML.apply({
            block : this.__self._name,
            elem : 'summ',
            content : {
                block : 'b-currency',
                tag: 'div',
                js: params,
                content: BEM.blocks['b-currency'].format(params)
            }
        }));

    },

    showError: function(message) {

        this.elem('placedesc', 'type', 'desc').addClass('i-hidden');
        this.elem('cell', 'type', 'summ').empty();

        this.findBlockInside('b-form-button').domElem.addClass('i-hidden');

        this.elem('placedesc', 'type', 'error')
            .html('<div class="b-500">' + message + '</div>')
            .removeClass('i-hidden');

    }

});

})();
