(function() {

include('../i-time/date_validator.js');

BEM.DOM.decl('b-rasp-search', {

    onSetMod : {

        'js' : function() {

            var _this = this,
                inputs = this.findBlocksInside({ blockName: 'b-form-input', modName: 'pick', modVal: 'yes' }),
                reverse = this.findBlockInside({ blockName: 'b-form-button', modName: 'mod', modVal: 'revert' }),
                searchTypeChange = this.findBlockInside('b-form-radio');

            this.from = inputs[0];
            this.to = inputs[1];
            this.when = this.findBlockInside({ blockName: 'b-form-input', modName: 'type', modVal: 'date' });

            this.errors = {};

            $.each([ 'from', 'to', 'when' ], function(i, name) {

                var block = _this[name];

                block && block.on('change', function() {

                    this.delMod('error');

                    delete _this.errors[name];

                    _this.showErrors();

                });

            });

            BEM.blocks['b-rasp-search__dataprovider'].on('showSuggestFoot', function(e, link) {
                _this.from.link = link;
                _this.to.link = link;
            });

            reverse.on('click', this.reverse, this);

            searchTypeChange && searchTypeChange.on('change', this._onChangeSearchType, this);

            this.bindTo('submit', this._onSubmit);

        }

    },

    _onSubmit: function(e) {

        var _this = this,
            errors = {},
            when = normalizeDate(this.when.val().toLowerCase()),
            messages = [];

        if(!this.from.val())
            errors.from = 'missing';

        if(!this.to.val())
            errors.to = 'missing';

        if(when && !checkDate(when))
            errors.when = 'invalid';

        this.errors = errors;

        e.preventDefault();

        if (!this.showErrors()) {
            var params = {
                fromName: this.from.val(),
                fromId: this.from.keyVal(),
                toName: this.to.val(),
                toId: this.to.keyVal(),
                when: when
            };

            window.location = this.domElem.attr('action') + "?" + $.param(params, true);
        }

    },

    showErrors: function() {

        var _this = this,
            errors = this.errors,
            messages = [];

        if(errors.from && errors.to)
            messages.push(BEM.I18N('b-rasp-search', 'specify-from-and-to'));
        else if(errors.from)
            messages.push(BEM.I18N('b-rasp-search', 'specify-from'));
        else if(errors.to)
            messages.push(BEM.I18N('b-rasp-search', 'specify-to'));

        if(errors.when)
            messages.push(BEM.I18N('b-rasp-search', 'fix-when'));

        if(messages.length) {

            $.each(errors, function(key) {
                _this[key].setMod('error', 'yes');
            });

            var action = $(BEMHTML.apply({
                block: 'b-search-action',
                mods: { type: 'error' },
                content: messages.join('<br/>')
            }));

            if(this._action) {
                this._action.replaceWith(action);
            } else {
                action.hide().insertAfter(this.domElem).slideDown();

            }

            this._action = action;

            return true;

        } else {

            this._action && this._action.slideUp(function() { $(this).remove(); });

            this._action = undefined;

            return false;

        }

    },

    reverse : function() {

        var fromState = this.from._getState(),
            toState = this.to._getState();

        this.from._setState(toState);
        this.to._setState(fromState);

    },

    _onChangeSearchType: function(e, data) {

        var params = e.block.elemParams(data.current);

        this.domElem.attr('action', params.action);

        function setSample(input, sample) {
            var elem = input.elem('samples');

            BEM.DOM.update(elem, BEMHTML.apply({
                block: 'b-form-input',
                elem: 'sample',
                content: {
                    block: 'b-link',
                    mods: { pseudo: 'yes' },
                    content: sample
                }
            }));
        }

        setSample(this.from, params.samples.from);
        setSample(this.to, params.samples.to);
    }

});

})();
