(function() {

Schedule = {};

include('../../../attic/js/utils.js');

Schedule.Widget = function(element, params) {
    var self = this;

    this.params = params;

    this.element = element;

    $('.b-style a', element).click(function(e) {
        self.changeColor(e, this);
    });

    // поддержка работы с буфером обмена - IE
    if (window.clipboardData && window.clipboardData.setData) {
        $('.copy-to-clipboard').removeClass('i-hidden');
    }

    $('.b-text input', element).click(function(e) {
        self.changeText(e, this);
    });

    $('#widget_form').submit(function(e) {
        self.formSubmit(e, this);
    });

    this.previewBackground = $('.b-widget', element)[0];
    this.previewText = $('.b-preview .text', element)[0];

    this.background_field = $('#id_background')[0];
    this.title_field = $('#user_text')[0];
    this.textarea_field = $('#user_textarea')[0];

    this.textareaObserver = new Schedule.Utils.InputObserver(this.textarea_field, 100);

    $(this.textarea_field).bind('valueChanged', function(e) {
        self.changeUserText(e, this);
    });

    this.picture_button = $('#picture_button')[0];
    this.code_block = $('#code_block')[0];
    this.code_textarea = $('#code_textarea')[0];

    $(this.code_textarea).click(function(e) {
        self.selectCode(e, this);
    });

    this.hideCode();

    this.style = '01';
    this.text = 'Вылетаю!';

    this.widget_code = '<a href="http://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70887/*http://' +
                        this.params['domain_name'] + '/thread/' + this.params['thread_uid'] + this.params['params'] +
                        '"><img src="http://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70886/*' +
                        this.params['picture'] + '" alt="' + this.params['alt'] + ', ' + this.params['station_from'] +
                        ' (' + this.params['dep_date'] + ') - ' + this.params['station_to'] + ' (' + this.params['arr_date'] +
                        ')" title="Подробнее о рейсе на Яндекс.расписания" style="border:0;" /></a><div style="font: 9px/9px ' +
                        'Arial; position: relative; top: -20px; margin-left: 100px;"><a href="http://rasp.yandex.ru" ' +
                        'style="color:#000;">я тоже хочу выбрать рейс!</a></div>';

};

Schedule.Widget.prototype = new function() {

    var getStyle = /_(\d+)_small\.png$/;

    /**
     * Меняет цвет стрелки.
     * @param e
     * @param a
     */
    this.changeColor = function(e, a) {
        e.preventDefault();

        $('.b-style li.current', this.element).removeClass('current');

        $(a).parent().addClass('current');

        this.style = getStyle.exec($('img', a)[0].src)[1];

        var new_class = 'b-widget b-widget_color_' + this.style;

        if(this.previewBackground.className.indexOf('b-widget_type_train') != -1){
            new_class += ' b-widget_type_train';
        }
        this.previewBackground.className = new_class;
        this.background_field.value = this.style;
        this.hideCode();
    };

    /**
     * Меняет текст.
     * @param e
     * @param input
     */
    this.changeText = function(e, input) {
        if (input.id == 'user_text') {
            this.textarea_field.disabled = false;
            if(this.textarea_field.value == 'Написать свой текст') {
                this.textarea_field.value = '';
            }
            this.text = this.textarea_field.value;
        } else {
            this.textarea_field.disabled = true;
            if (this.textarea_field.value == '') {
                this.textarea_field.value = 'Написать свой текст';
                this.textareaObserver.saveState();
            }
            this.text = input.value;
        }

        $(this.previewText).text(this.text);
        this.hideCode();
    };

    this.changeUserText = function(e) {
        if (e.value.length > 20) {
            e.value = e.value.substr(0, 20);
        }
        $(this.previewText).text(e.value);
        this.text = e.value;
        this.title_field.value = this.text;
        this.hideCode();
    };

    this.showCode = function(picture_url) {
        $(this.picture_button).add('#wait_block').addClass('i-hidden');
        $(this.code_block).removeClass('i-hidden');

        this.code_textarea.value = this.widget_code.replace(/(<img src=")(\S*)(".*)/, "$1http://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70886/*"+ picture_url +"$3");
    };

    this.hideCode = function() {
        $(this.picture_button).removeClass('i-hidden');

        $(this.code_block).add('#wait_block').addClass('i-hidden');
    };

    this.onError = function () {
        this.hideCode();
        alert('Извините, произошла ошибка. Попробуйте еще раз.');
    };

    this.formSubmit = function(event, form) {
        var self = this,
            data = $(form).serializeArray();

        $.merge(data, $('input[type=submit]', form));

        event.preventDefault();

        $(this.picture_button).addClass('i-hidden');
        $('#wait_block').removeClass('i-hidden');

        $.ajax({
            url: $(form).attr('action'),
            dataType: 'json',
            data: $.param(data, true),
            success: function (r) {
                if(r) {
                    self.showCode(r['picture_url']);
                } else {
                    // Пришёл null, данных нет
                    self.onError();
                }
            },
            error: function() {
                self.onError();
            }
        });
    };

    this.selectCode = function(e, element) {
        element.select();
    };
};

BEM.DOM.decl('b-route-widget', {

    onSetMod: {

        'js': function() {
            var _this = this;
            $('.js-route-widget').each(function() {
                new Schedule.Widget(this, _this.params);
            });
        }
    }
});

})();