BEM.decl('i-url', {}, {

    parseQuery: function(query, wantArrays) {

        function parseComponent(part) {

            if(!part) return part;

            try {
                return decodeURIComponent(part.replace(/\+/g, ' '));
            } catch (e) {
                return '';
            };

        }

        var params = {};

        $.each(query.match(/^\??(.*)$/)[1].split('&'), function(i, p) {

            p = p.split('=');

            var key = p[0],
                value = parseComponent(p[1]),
                current;

            if(value !== undefined) {

                current = params[key];

                if(current) {

                    if(!(current instanceof Array))
                        current = params[key] = [current];

                    current.push(value);

                } else {
                    params[key] = wantArrays ? [value] : value;
                }

            }

        });

        return params;

    },

    updateParams: function(params, newParams, skip) {

        skip = skip || [];

        $.each(newParams, function(name, value) {

            var m;

            if(value === null) {

                if($.inArray(name, skip) != -1)
                    return;

                delete params[name];

            } else {

                m = /(.*)__(add|remove)$/.exec(name);

                if(m) {

                    name = m[1];

                    if($.inArray(name, skip) != -1)
                        return;

                    var action = m[2],
                        values = params[name],
                        i;

                    if(values === undefined)
                        values = params[name] = [];
                    else if(!(values instanceof Array))
                        values = params[name] = [values];

                    if(action == 'add') {

                        value = String(value);

                        i = $.inArray(value, values);

                        if(i == -1)
                            values.push(value);

                    } else if(action == 'remove') {

                        value = String(value);

                        i = $.inArray(value, values);

                        if(i != -1)
                            values.splice(i, 1);

                    }

                } else {

                    if($.inArray(name, skip) != -1)
                        return;

                    if($.isArray(value))
                        params[name] = $.map(value, String);
                    else
                        params[name] = String(value);

                }

            }

        });

    },

    changeParams: function(url, params, skip) {

        var m = /^(.*)(\?.*?)(#.*)?$/.exec(url),
            base = m ? m[1] : url,
            query = m ? this.parseQuery(m[2]) : {},
            hash = m && m[3] ? m[3] : '';

        this.updateParams(query, params, skip);

        return base + '?' + $.param(query, true) + hash;

    }

});
