include('BlueStation.js');

var $blueCallbacks = $('<div></div>');
function Metaroute() {
    var self,
        blueStations;

    blueStations = (function() {
        var self,
            stations = {},
            $list = $('#stations-list');

        self = {
            add : function(data) {
                var blueStation = BlueStation(data);
                self.destructById(blueStation.id);
                stations[blueStation.id] = blueStation;
                // Добавить станцию в блок
                stations[blueStation.id].get$tr().appendTo($list);
            },

            update : function(data) {
                $.each(stations, function(j, s) {
                    s.destruct();
                });
                stations = {};

                $.each(data, function(j, s) {
                    self.add(s);
                });

                self.replaceGeoLess();
            },

            automapPlaced : function() {
                function plural(n, forms) {
                    var p = (n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
                    return forms[p];
                }
                var stations2automap = [];
                $.each(stations, function(j, blueStation){
                    if (!blueStation.www_station.id && blueStation.placed) {
                        stations2automap.push(blueStation);
                    }
                });
                if (stations2automap.length) {
                    var num = stations2automap.length,
                        question = ngettext('Создать станцию', 'Создать станции', num) +' в:';
                    if (city.title) {question = question + ' ' + city.title;}
                    if (region.title) {question = question + ' ' + region.title;}
                    if (district.title) {question = question + ' ' + district.title;}
                    if (country.title) {question = question + ' ' + country.title;}
                    question = question + '?'
                    if (confirm(question)) {
                        $.each(stations2automap, function(j, blueStation){
                            blueStation.newMapping();
                        });
                        setTimeout(function(){
                            wwwStations.redraw();
                            metarouteCheckUnmappedCount();
                        }, 618);
                    }
                }
            },

            resetUnplaced : function() {
                $.each(stations, function(j, s) {
                    if (!s.www_station.id || !s.www_station.geo) {
                        s.placed = false;
                    }
                });
            },

            replaceGeoLess : function() {
                var bounds = map.getBounds(),
                    begin,
                    middles=[],
                    end,
                    ps = [],
                    orderedStations = $.map(stations, function(blueStation) {return blueStation});


                ps.push({'placed':true, 'lon':bounds[0][0], 'lat':bounds[0][1]});

                orderedStations.sort(function(one, two) {return one.number - two.number})
                $.each(orderedStations, function(j, s) {
                    ps.push(s)
                });
                ps.push({'placed':true, 'lon':bounds[1][0], 'lat':bounds[1][1]});
                $.each(ps, function(j, p){
                    if (p.lon && p.lat && (p.placed || p.www_station.id)) {
                        if (middles.length) {
                            end = p;
                            // Расставить middles между begin и end
                            var spans_count = (middles.length+1);
                            var dx = (end.lon - begin.lon) / spans_count;
                            var dy = (end.lat - begin.lat) / spans_count;
                            $.each(middles, function(index, m) {
                                m.lon = ((index+1)*dx) + begin.lon;
                                m.lat = ((index+1)*dy) + begin.lat;
                                m.pmUpdate();
                            });
                        }
                        begin = p;
                        middles = [];
                    } else {
                        middles.push(p);
                    }
                });
            },

            getById : function(blueStationId) {
                return stations[blueStationId];
            },

            // Интерфейсное удаление
            destructById : function(blueStationId) {
                if (stations[blueStationId]) {
                    stations[blueStationId].destruct();
                    delete stations[blueStationId];
                }
            },

            each : function(callback) {
                    if (!$.isEmptyObject(stations)) {
                        $.each(stations, function(j, s) {
                        callback(j, s);
                    });
                }
            }

        };

        $blueCallbacks.bind('stationDrag', function(e, data) {
            var maxDistance = 8,
                closest = wwwStations.findClosest(data.station.getPm(), maxDistance);

            if (closest) {
                data.station.setStyle('normal');
                data.station.closestWwwStation = closest;
            } else {
                data.station.setWhatStyle();
                data.station.closestWwwStation = null;
            }
        });

        $blueCallbacks.bind('stationDragEnd', function(e, data) {
            var blueStation = data.station,
                point = blueStation.pm.geometry.getCoordinates(),
                data = { 'lon': point[0], 'lat': point[1] };

            if (blueStation.www_station.id) {

                if (confirm((blueStation.www_station.geo ? gettext("Переместить") : gettext("Геокодировать")) + gettext(" станцию ") +
                            blueStation.www_station.id + " " + blueStation.www_station.title + "?")) {
                    $.post('/admin/blue/station_move/' + blueStation.www_station.id + '/',
                        data,
                        function(r) {
                            if (r.status == 'ok') {
                                blueStation.update(data);
                                wwwStations.redraw();
                            } else {
                                blueStation.update();
                                alert(gettext('Не удалось переместить'));
                            }
                        }
                    ).error(function(){
                        alert(gettext('Ошибка связи с сервером'));
                    });
                } else {
                    blueStation.pmUpdate();
                }
            } else {
                // Перетаскивание красной станции на станцию в базе инициирует диалог привязки
                if (blueStation.closestWwwStation) {
                    blueStation.mapToWwwStation(blueStation.closestWwwStation);
                } else {
                    blueStation.placed = true;
                    blueStation.lon = point[0];
                    blueStation.lat = point[1];
                    blueStation.setWhatStyle();
                }
            }

            self.replaceGeoLess();
        });

        return self;
    })();


    $('.b_unmap_station').live('click', function() {
        map.balloon.close();
        var station_id = $(this).attr('data-id'),
            station = blueStations.getById(station_id);
        if (station) {
            station.unmap();
        }
    });

    function updateRoute(data) {
        // 1 Информация
        self.id = data.id;
        self.path_key = data.path_key;

        ymapsUtils.setHashParams({'route_id': self.id});

        // 2 Станции следования
        blueStations.update(data.stations);

        // 3 Ссылки на данные от поставщика
        if (Object.keys(data.originalTherads).length) {
            var routesListElem = $('#routes-list');

            routesListElem.append('<br><strong>Исходные данные нитки:</strong><br>');
            $.each(data.originalTherads, function(id, title) {
                var url = 'http://rasp.smacker.rasp.dev.yandex.ru/admin/importinfo/originalthreaddata/' + id + '/';
                routesListElem.append('<a href="' + url + '" target="_blank">' + id + ' ' + title + '</a><br>');
            });
        }
    }

    wwwStations.bind('joinrollback', function(e, data) {
        self.select(self.id);
    });

    self = {

        select : function(id, kwargs) {
            if (typeof(kwargs) == 'undefined') {
                kwargs = {};
            }

            if (!id) {
                id = $('#threads > option').attr('value');
            };

            self.id = id;

            $('#threads').val(id);
            $('#threads').trigger('change.select2');

            $('#routes-list').empty();

            if (metathreads[id]) {
                var threads = metathreads[id].threads;
                $.each(threads, function(i, t){
                    $('#routes-list').append(
                        '<div data-id="' + t.id + '"><span>' + t.id + ' ' + t.title + '</span></div>'
                    );
                });
            }

            $.getJSON('/admin/blue/thread/' + id + '/', {}, function(data) {
                // Центрировать на карте
                if (!kwargs.doNotFocuse) {
                    // Центрировать на карте
                    map.setBounds(data.bounds, { precizeZoom : true });
                }

                updateRoute(data);
            });

        },

        checkUnmappedCount : function() {
            var count = 0,
                $option = $('#threads > option[value=' + self.id + ']'),
                title;

            blueStations.each(function(j, s) {
                if (!s.www_station.id )
                    count += 1;
            });

            title = $option.attr('data-title');
            if (count)
                title = '# ' + title + ' (' + count + ') #';

            $option.text(title);
            $option.attr('data-unmapped', count);
        },

        saveFuzzyFlag: function(blueStationId, fuzzyFlag, pathKey) {
            blueStations.getById(blueStationId).saveFuzzyFlag(fuzzyFlag, self.path_key);
        },

        getTsiStationById: function(tsiId) {
            return blueStations.getById(tsiId);
        },

        updateTsiStationFlags: function(tsiStationId, tsiStationFlags) {
            var tsiStation = blueStations.getById(tsiStationId);
            var data = _.extend({'path_key': self.path_key}, tsiStationFlags);
            return $.post('/admin/blue/station/' + tsiStation.id + '/?action=save_fuzzy_flag', data, function(response) {
                if (response.status == 'ok') {
                    tsiStation.update(tsiStationFlags);
                } else {
                    alert(gettext('Не удалось сохранить флаги'));
                }
            });
        }

    };

    // Bindings
    $('#threads').change(function() {
        var route_id = $(this).val();
        self.select(route_id);
    });

    $('#thread-next').click(function() {
        var nextThread = $('#threads > option:selected').next();

        if (nextThread.length) {
            self.select(nextThread.attr('value'));
        }
    });

    $('#thread-next-unmapped').click(function() {
        var curThread = $('#threads > option:selected'),
            nextUnmappedThread = curThread.next();

        while(nextUnmappedThread.length && nextUnmappedThread.attr('data-unmapped') == 0) {
            nextUnmappedThread = nextUnmappedThread.next();
        }
        if (nextUnmappedThread.length == 0) {
            nextUnmappedThread = $('#threads > option.unmapped').eq(0);
        }

        if (nextUnmappedThread.length) {
            self.select(nextUnmappedThread.attr('value'));
        } else {
            alert(gettext('Не найдено других ниток с непривязанными станциями'));
        }
    });

    $('#autoplace-unmapped-stations').click(function() {
        blueStations.resetUnplaced();
        blueStations.replaceGeoLess();
    });

    $('#automap-placed-stations').click(function() {
        blueStations.automapPlaced();
    });

    $('#map').delegate('.b_new_station_map', 'click', function() {
        var station = {},
            $form = $($(this).parents('form')),
            station_id = $form.attr('data-id'),
            blueStation = blueStations.getById(station_id);

        station.settlement_id = $form.find('input[name=settlement_id]').val();
        station.region_id = $form.find('input[name=region_id]').val();
        station.district_id = $form.find('input[name=district_id]').val();
        station.country_id = $form.find('input[name=country_id]').val();
        station.title = $form.find('input[name=title]').val();
        station.majority_id = $form.find('select[name=majority_id]').val();
        station.station_type_id = $form.find('select[name=station_type_id]').val();
        station.t_type_id = $form.find('select[name=t_type_id]').val();

        if (!blueStation || !station.title ||
            (!station.settlement_id && !station.region_id && !station.country_id)) {
            alert(gettext('Не хватает параметров для создания станции'));
            return;
        }

        blueStation.newMapping(station);
    });

    // поиск рейса
    $('#id_thread_id_change').click(function() {
        var val = $('#id_thread_search').val();

        var isNumber = (! isNaN(parseInt(val)));

        if (metathreads[val]) {
            metaroute.select(val);
            return;
        } else {
            $.each(metathreads, function(j, metathread) {
                $.each(metathread.threads, function(i, thread) {
                    if (isNumber && (thread.id.toString() == val)) {
                        metaroute.select(j);
                        return;
                    } else {
                        if (thread.title.indexOf(val) != -1) {
                            metaroute.select(j);
                            return;
                        }
                    }
                })
            })
        }
    });

    return self;
}
