function changeThreadDay(month, day, value) {
    // При value=null, делать toggle

    pos = (month - 1) * 31 + day - 1;

    yearDays = y5.$('id_year_days').value;

    if(value == null) {
        value = yearDays.charAt(pos) == '1' ? '0' : '1';
    };

    yearDays = yearDays.substr(0, pos) + value + yearDays.substr(pos + 1);
    y5.$('id_year_days').value = yearDays;

    y5.Element.attributes(y5.$('day_' + month + '_' + day), 'class', value == '1' ? 'day_present' : 'day_absent');

    return false;
};

function changeMonth(el, type) {
    var $month = $(el).parents('.month_table:first');

    $month.find('td:not(.month_action, .title):has(a)').each(function () {
        var $td = $(this),
            data = $(this).find('a').attr('id').split('_'),
            month = parseInt(data[1]),
            day = parseInt(data[2]),
            value;

        switch(type) {
            case 'all': value = '1'; break;
            case 'even': value = day % 2 == 1 ? '0' : '1'; break;
            case 'odd': value = day % 2 == 1 ? '1' : '0'; break;
            case 'workday':
            case 'holiday':
                value = $td.hasClass(type) ? '1': '0';
                break;
            case 'none': value = '0'; break;
        }

        changeThreadDay(month, day, value);
    });

    return false;
};

function changeYear(type) {
    $('.month_table tbody').each(function() {
        changeMonth(this, type);
    });

    return false;
};

function fixCalendar() {
    // Привести календарь в соответствие инпуту
    yearDays = y5.$('id_year_days').value;
    for(m = 1; m <= 12; m++) {
        for(d = 1; d <= 31; d++) {
            pos = (m - 1) * 31 + d - 1;
            y5.Element.attributes(y5.$('day_' + m + '_' + d), 'class', yearDays.charAt(pos) == '1' ? 'day_present': 'day_absent');
        }
    }
};
