process.env.XJST_ASYNCIFY = true;

var fs = require('fs');

module.exports = function(config) {
    config.setLanguages(['ru', 'en']);

    if (!fs.existsSync('desktop.bundles/common')) {
        fs.mkdirSync('desktop.bundles/common');
    }

    // Добавление набора нод в сборку.
    config.nodes('desktop.bundles/*');

    config.mode('development', function() {
        config.nodeMask(/desktop\.bundles\/.*/, function(nodeConfig) {
            nodeConfig.addTechs([
                [ require('enb/techs/file-copy'), { sourceTarget: '?.{lang}.js', destTarget: '_?.{lang}.js' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.{lang}.pub.js', destTarget: '_?.{lang}.pub.js' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.all.pub.js', destTarget: '_?.all.pub.js' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.css', destTarget: '_?.css' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.ie6.css', destTarget: '_?.ie6.css' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.ie7.css', destTarget: '_?.ie7.css' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.ie8.css', destTarget: '_?.ie8.css' } ],
                [ require('enb/techs/file-copy'), { sourceTarget: '?.ie9.css', destTarget: '_?.ie9.css' } ]
            ]);
        });
    });

    config.mode('production', function() {
        config.nodeMask(/desktop\.bundles\/.*/, function(nodeConfig) {
            nodeConfig.addTechs([
                [ require('enb/techs/borschik'), { sourceTarget: '?.{lang}.js', destTarget: '_?.{lang}.js', minify: true, freeze: false } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.{lang}.pub.js', destTarget: '_?.{lang}.pub.js', minify: true, freeze: false } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.pub.js', destTarget: '_?.pub.js', minify: true, freeze: false } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.css', destTarget: '_?.css', minify: true, freeze: true } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.ie6.css', destTarget: '_?.ie6.css', minify: true, freeze: true } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.ie7.css', destTarget: '_?.ie7.css', minify: true, freeze: true } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.ie8.css', destTarget: '_?.ie8.css', minify: true, freeze: true } ],
                [ require('enb/techs/borschik'), { sourceTarget: '?.ie9.css', destTarget: '_?.ie9.css', minify: true, freeze: true } ]
            ]);
        });
    });

    // Сборка страниц
    config.nodeMask(/^desktop.bundles\/(?!tpl-).*/, function(nodeConfig) {
        var path = nodeConfig.getPath();
        if (path === 'desktop.bundles/common') {
            return;
        }

        nodeConfig.addTechs([
            [ require('enb/techs/levels'), { levels: getLevelsDesktop() } ],
            [ require('enb/techs/file-provider'), { target: '?.bemjson.js' } ],
            require('enb/techs/bemdecl-from-bemjson'),
            require('enb/techs/deps-old'),
            require('enb/techs/files'),
            [ require('enb/techs/i18n-merge-keysets'), { lang: 'all' }],
            [ require('enb/techs/i18n-merge-keysets'), { lang: '{lang}' }],
            [ require('enb/techs/i18n-lang-js'), { lang: 'all' } ],
            [ require('enb/techs/i18n-lang-js'), { lang: '{lang}' } ],
            require('enb-bemhtml/techs/bemhtml'),
            require('enb/techs/priv-js'),
            [ require('enb/techs/priv-js-i18n'), { lang: '{lang}' } ],
        ]);
        nodeConfig.addTargets(['?.{lang}.priv.js', '?.deps.js']);

    });

    // Сборка шаблонов
    config.nodeMask(/^desktop.bundles\/(tpl-).*/, function(nodeConfig) {
        nodeConfig.addTechs([
            [ require('enb/techs/levels'), { levels: getLevelsDesktop() } ],
            [ require('enb/techs/file-provider'), { target: '?.bemjson.js' } ],
            require('enb/techs/bemdecl-from-bemjson'),
            require('enb/techs/deps-old'),
            require('enb-bemhtml/techs/bemhtml'),
            require('enb/techs/files'),
            [ require('enb/techs/js') ],
            [ require('enb/techs/i18n-merge-keysets'), { lang: 'all' }],
            [ require('enb/techs/i18n-merge-keysets'), { lang: '{lang}' }],
            [ require('enb/techs/i18n-lang-js'), { lang: 'all' } ],
            [ require('enb/techs/i18n-lang-js'), { lang: '{lang}' } ],
            require('enb/techs/html-from-bemjson'),
            [ require('enb/techs/html-from-bemjson-i18n-sync'), { lang: '{lang}'}]
        ]);
        nodeConfig.addTargets(['?.{lang}.html', '?.deps.js']);
    });

    // Сборка общих CSS&JS
    config.node('desktop.bundles/common', function(nodeConfig) {
        var pagesDeps = [],
            addTechsAttrs = [
                [ require('enb/techs/levels'), { levels: getLevelsDesktop(config) } ],
                require('enb/techs/files'),
                [ require('enb/techs/js') ],
                require('enb-bemhtml/techs/bemhtml'),
                require('enb/techs/css'),
                [ require('enb/techs/css-ie6'), { sourceSuffixes: ['css', 'ie.css', 'ie6.css'] }],
                [ require('enb/techs/css-ie7'), { sourceSuffixes: ['css', 'ie.css', 'ie7.css'] }],
                [ require('enb/techs/css-ie8'), { sourceSuffixes: ['css', 'ie.css', 'ie8.css'] }],
                [ require('enb/techs/css-ie9'), { sourceSuffixes: ['css', 'ie9.css'] }]
            ];

        // Проходимся по существующим страницам
        fs.readdirSync('desktop.bundles').map(function (page) {
            if (page !== 'common') {
                // Копируем bemdecl с каджой страницы внутрь common
                addTechsAttrs.push([ require('enb/techs/deps-provider'), { sourceNodePath: 'desktop.bundles/' + page, depsTarget: page + '.deps.js' } ]);

                pagesDeps.push(page + '.deps.js');
            }
        });

        addTechsAttrs.push(
            [ require('enb/techs/deps-merge'), { depsSources: pagesDeps } ],
            [ require('enb/techs/i18n-merge-keysets'), { lang: 'all' }],
            [ require('enb/techs/i18n-merge-keysets'), { lang: '{lang}' }],
            [ require('enb/techs/i18n-lang-js'), { lang: 'all' } ],
            [ require('enb/techs/i18n-lang-js'), { lang: '{lang}' } ],
            [ require('enb/techs/js-i18n'), { lang: 'all' } ],
            [ require('enb/techs/js-i18n'), { lang: '{lang}' } ],
            [ require('enb/techs/pub-js-i18n'), {
                jsTarget: '?.js',
                lang: 'all',
                allLangTarget: '?.lang.all.js',
                langTarget: '?.lang.{lang}.js',
                target: '?.{lang}.pub.js'
            } ]
        );

        nodeConfig.addTechs(addTechsAttrs);
        nodeConfig.addTargets([
            '_common.{lang}.pub.js', '_common.css', '_common.ie6.css', '_common.ie7.css',
            '_common.ie8.css', '_common.ie9.css']);
    });

    function getLevelsDesktop() {
        return [
            { 'path': 'vendors/bem-bl/blocks-common', 'check':false },
            { 'path': 'vendors/bem-bl/blocks-desktop', 'check':false },
            { 'path': 'vendors/lego/blocks-common', 'check':false },
            { 'path': 'vendors/lego/blocks-desktop', 'check':false },
            { 'path': 'vendors/islands-components/common.blocks', 'check':false },
            { 'path': 'vendors/islands-components/desktop.blocks', 'check':false },
            { 'path': 'vendors/islands-page/common.blocks', 'check':false },
            { 'path': 'vendors/islands-page/desktop.blocks', 'check':false },
            { 'path': 'common.blocks', 'check':true },
            { 'path': 'desktop.blocks', 'check':true }
        ].map(function(l) { return config.resolvePath(l); });
    }
};
