var app = require('app'),
    HistoryController = require('history'),
    MaintenanceController = require('maintenance'),
    // Элементы управления карты
    infoControl = require('controls/info'),
    gorodaControl = require('controls/goroda'),
    // Модули
    WwwStationsController = require('modules/www_stations'),
    PackagesController = require('modules/packages'),
    ThreadsController = require('modules/blue_threads'),
    StationsController = require('modules/blue_stations'),
    OriginDataController = require('modules/blue_original_data');


var config = {
    // Urls
    configUrl: '/admin/blue/api/config/',
    packagesUrl: '/admin/blue/api/packages/',
    threadsUrl: '/admin/blue/api/threads/',
    stationsUrl: '/admin/blue/api/stations/',
    wwwStationsUrl: '/admin/www_stations/api/stations/',

    // UI urls
    packageAdminUrl: '/admin/importinfo/twostageimportpackage/',
    packageAddUrl: '/admin/importinfo/twostageimportpackage/add/',
    wwwStationAdminUrl: '/admin/www/station/',
    stationAdminUrl: '/admin/importinfo/twostageimportstation/',
    originDataUrl: '/admin/importinfo/originalthreaddata/',

    // UI
    mapTools: [
        infoControl,
        gorodaControl,
        'wwwStations.controls.stationsControl'
    ],
    sidebarBlocks: [
        ['packages', 'selectBlock'],
        ['threads', 'selectBlock'],
        ['stations', 'selectBlock'],
        ['originData', 'infoBlock']
    ],
    moduleOptions: {
        packages: {},
        threads: {}
    },

    // defaults form values
    defaults: {
        majority: 4,
        stationType: 11,
        transportType: 3
    },

    // Связь тип транспорта - тип станции
    stationTypesByTransport: {
        1: 1,  // Поезд - станция
        2: 9,  // Самолёт - аэропорт
        3: 11, // Автобус - автобусная остановка
        4: 16, // Речной транспорт - Речной вокзал
        5: 17, // Морской транспорт - Морской вокзал
        6: 1,  // Пригородный поезд - станция
        7: 9,  // Вертолёт - аэропорт
        8: 11, // Городской транспорт - автобусная остановка
        9: 11  // Псевдо-гортранс - автобусная остановка
    }
};

app.addModules([
    { name: 'history', controller: HistoryController },
    { name: 'maintenance', controller: MaintenanceController },
    { name: 'wwwStations', controller: WwwStationsController },
    { name: 'packages', controller: PackagesController },
    { name: 'threads', controller: ThreadsController },
    { name: 'stations', controller: StationsController },
    { name: 'originData', controller: OriginDataController }
]);

app.start(config);
