var BackboneYmaps = require('Backbone.Ymaps');

var BalloonPlacemark = BackboneYmaps.Placemark.extend({
    events: {
        'balloonopen': 'onBalloonOpen',
        'balloonclose': 'onBalloonClose',
        'mouseenter': 'onMouseEnter',
        'mouseleave': 'onMouseLeave'
    },

    balloonContent: gettext('Загрузка...'),

    onMouseEnter: function() {
        this.model.trigger('hover');
    },

    onMouseLeave: function() {
        this.model.trigger('unhover');
    }

});

module.exports = BalloonPlacemark;
