// кнопка информация о точке на карте

var app = require('app'),
    infoCursor;

var getInfo = function(e) {
    var position = e.get('coordPosition');
    ymaps.geocode(position, { results: 1 }).then(function (res) {
        var firstGeoObject = res.geoObjects.get(0);

        app.map.balloon.open(position, firstGeoObject.properties.get('balloonContentBody'));
    });
};

function onInfoSelect() {
    infoCursor = app.map.cursors.push('help');
    app.map.events.add('click', getInfo);
}

function onInfoDeselect() {
    infoCursor && infoCursor.remove();
    app.map.events.remove('click', getInfo);
}


module.exports = function() {
    var infoButton = new ymaps.control.Button({
        data: {
            image: app.config.staticUrl + 'app/controls/info/info.png',
            title: gettext('Получить информацию')
        }
    });

    infoButton.events.add('select', onInfoSelect);
    infoButton.events.add('deselect', onInfoDeselect);

    return infoButton;
};
