var _ = require('underscore');


var Maps = function(options) {
    this.initialize(options);
};

_.extend(Maps.prototype, {

    initialize: function(options){
        this.app = options.app;
        this._typeSelector = new ymaps.control.TypeSelector();

        this._mapTools = new ymaps.control.RadioGroup({ items: [] });
        this.controls = [
            'zoomControl',
            'scaleLine',
            this._mapTools
        ];
        this.mapTools = [
            new ymaps.control.mapTools.button.Drag(),
            new ymaps.control.mapTools.button.Magnifier(),
            this._typeSelector
        ];

        if (options.mapTools) {
            this.mapTools = this.mapTools.concat(options.mapTools);
        }

        if (options.controls) {
            this.controls = this.controls.concat(options.controls);
        }

        this._buildMap();
        this.bind();

        this.app.map = this.map;
        this.app.trigger('maps:initialized');
    },

    bind: function() {
        this.app.on('maps:setCenter', _.debounce(function() {
            this.map.setCenter.apply(this.map, arguments);
        }, 200), this);

        this.app.on('maps:setBounds', _.debounce(function() {
            this.map.setBounds.apply(this.map, arguments);
        }, 200), this);
    },

    on: function(name, callback, context) {
        this.map.events.add(name, callback, context);
    },

    off: function(name, callback, context) {
        this.map.events.remove(name, callback, context);
    },

    _buildMap: function() {
        //Загружаем народные слои https://st.yandex-team.ru/RASPADMIN-775
        var layerName = 'yandex#oldMaps';
        var OldMapsLayer = function () {
            return new ymaps.Layer('https://0%d.pvec.maps.yandex.net/?l=pmap&lang=ru_RU&%c');
        };
        ymaps.layer.storage.add('yandex#oldMaps', OldMapsLayer);
        var oldMapType = new ymaps.MapType('Народный слой', [layerName]);
        ymaps.mapType.storage.add(layerName, oldMapType);

        this._typeSelector.addMapType(layerName);

        this.map = new ymaps.Map('maps', {
            center: [37.64, 55.76], // Москва
            zoom: 10,
            // включаем масштабирование карты колесом
            behaviors: ['default', 'scrollZoom'],
            type: layerName
        });
    },

    addControls: function() {
        _.each(this.controls, function(control) {
            if (_.isFunction(control)) {
                control = control();
            }

            this.map.controls.add(control);
        }, this);

        _.each(this.mapTools, function(tool) {
            if (_.isFunction(tool)) {
                tool = tool();
            } else if (_.isString(tool)) {
                var parts = tool.split('.');
                tool = _.reduce(parts, function(module, key) {
                    return module[key];
                }, this.app.modules);
            }
            this._mapTools.add(tool);
        }, this);
    }

});

module.exports = Maps;
