var app = require('app'),
    _ = require('underscore'),
    BemItemView = require('common/bemCompositeView');


var StationsView = BemItemView.extend({
    template: require('templates/original-data'),

    ui: {
        list: '.list'
    },

    onRender: function() {
        this.ui.list.empty();
        _.each(this.model.get('originalThreads'), function(thread) {
            this.ui.list.append(this._makeLink(thread));
        }, this);
    },

    _makeLink: function(thread) {
        return BEMHTML.apply({
            block: 'link',
            target: '_blank',
            url: app.config.originDataUrl + thread.id,
            content: thread.title
        });
    }
});

module.exports = StationsView;
