var BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions'),
    setFuzzy = require('fuzzy');

var StationMappedForm = BemItemView.extend({
    template: require('templates/station-mapped-form'),

    events: {
        'click @ui.unmap': 'unmap',
        'click @ui.save': 'save'
    },

    ui: {
        code: '.js-code',
        title: '.js-title',

        wwwId: '.js-www-station-id',
        wwwTitle: '.js-www-station-title',
        wwwAdminLink: '.js-www-admin-link',
        wwwThreadUrl: '.js-www-thread-url',
        fuzzyLink: '.js-fuzzy-link',

        majority: ['.js-majority', 'select'],
        stationType: ['.js-station-type', 'select'],
        transportType: ['.js-transport-type', 'select'],

        fuzzy: ['.js-fuzzy', 'radio-button'],
        searchableFrom: ['.js-searchable-from', 'radio-button'],
        searchableTo: ['.js-searchable-to', 'radio-button'],
        schedule: ['.js-station-schedule', 'radio-button'],
        fuzzyValue: ['.js-fuzzy-value', 'radio-value'],
        searchableFromValue: ['.js-searchable-from-value', 'radio-value'],
        searchableToValue: ['.js-searchable-to-value', 'radio-value'],
        scheduleValue: ['.js-station-schedule-value', 'radio-value'],

        unmap: ['.js-unmap', 'button'],
        save: ['.js-save', 'button']
    },

    templateHelpers: function() {
        var wwwStation = this.model.get('www_station'),
            threadUrl = '/admin/importinfo/twostageimportthread/?threadstations__station__station_mapping__station=',
            fuzzyUrl = '/admin/importinfo/tsithreadstationflag/';

        return {
            adminUrl: this.model.getAdminUrl(),
            wwwAdminUrl: wwwStation.getAdminUrl(),
            wwwThreadUrl: threadUrl + wwwStation.get('id'),
            fuzzyFlagUrl: fuzzyUrl + this.model.get('fuzzy_flag_id')
        };
    },

    onRender: function() {
        var wwwStation = this.model.get('www_station');

        // Majority
        this.ui.majority.setOptions(makeOptions('station_majorities'), wwwStation.get('majority_id'));

        // Station type
        this.ui.stationType.setOptions(makeOptions('station_types', 'name'), wwwStation.get('station_type_id'));

        // Transport type
        this.ui.transportType.setOptions(makeOptions('t_types'), wwwStation.get('t_type_id'));

        // Fuzzy
        if (!this.model.get('fuzzy_flag_id')) {
            this.ui.fuzzyLink.parent().parent().hide();
        }
        if (this.model.get('first')) {
            this.ui.fuzzy.domElem.parent().parent().hide();
        }
        setFuzzy(this.model, this.ui, 'fuzzy', 'is_fuzzy');
        setFuzzy(this.model, this.ui, 'searchableFrom', 'is_searchable_from');
        setFuzzy(this.model, this.ui, 'searchableTo', 'is_searchable_to');
        setFuzzy(this.model, this.ui, 'schedule', 'in_station_schedule');
    },

    unmap: function() {
        if (!confirm(gettext('Отвязать станцию') + '?')) {
            return;
        }

        this.model.unmap();
        this.trigger('close');
    },

    save: function() {
        var wwwStation = this.model.get('www_station');

        this.model.set({
            'is_fuzzy': this.ui.fuzzy.val(),
            'is_searchable_from': this.ui.searchableFrom.val(),
            'is_searchable_to': this.ui.searchableTo.val(),
            'in_station_schedule': this.ui.schedule.val()
        });

        wwwStation.set({
            'majority_id': this.ui.majority.val(),
            'station_type_id': this.ui.stationType.val(),
            't_type_id': this.ui.transportType.val()
        });

        this.model.save();

        this.trigger('close');
    }
});

module.exports = StationMappedForm;
