var app = require('app'),
    BemItemView = require('common/bemItemView');

var StationView = BemItemView.extend({
    template: require('templates/station-item'),

    ui: {
        link: ['.link', 'link'],
        nativeLink: '.link'
    },

    events: {
        'mouseover @ui.nativeLink': 'onHover',
        'mouseleave @ui.nativeLink': 'onUnHover',
        'click @ui.nativeLink': 'onClick',
    },

    modelEvents: {
        'change': 'render'
    },

    onRender: function() {
        var type = this.model.getType();

        if (type === 'finished' || type === 'mapped') {
            this.ui.link.setMod('mapped', 'yes');
        }
    },

    onHover: function() {
        this.model.trigger('hover');
    },

    onUnHover: function() {
        this.model.trigger('unhover');
    },

    onClick: function() {
        var lon = this.model.get('lon'),
            lat = this.model.get('lat');

        if (lon && lat) {
            app.trigger('maps:setCenter', [lon, lat], 11, { duration: 330 });
        }
    }
});

module.exports = StationView;
