var Marionette = require('marionette'),
    ThreadCollection = require('modules/blue_threads/collection'),
    ThreadsView = require('modules/blue_threads/view');

var ThreadsController = Marionette.Controller.extend({
    initialize: function(options) {
        this.app = options.app;
        this.initValue = options.moduleOptions.threads.id;
        this.__packageInitValue = options.moduleOptions.packages.id;
        this.collection = new ThreadCollection();

        this.app.on('package:changed', this.setPackage, this);
    },

    // Api
    setPackage: function(options) {
        options = options || {};

        var package = options.model;

        this.collection.setPackage(package);

        if (!package) {
            this.collection.reset();
        } else {
            this.collection.fetch({ reset: true });
        }
    },

    setThread: function(options) {
        options = options || {};
        this.app.currentThread = options.model;
        this.app.trigger('thread:changed', options);

        var threadType;
        if (this.collection.package) {
            threadType = this.collection.package.get('t_type_id');
        } else {
            threadType = this.app.config.transportType;
        }
        this.app.trigger('wwwStations:setSelected', threadType);
    },

    // Блоки
    selectBlock: function(region) {
        var view = new ThreadsView({
            collection: this.collection,
            value: this.initValue
        });

        this.listenTo(view, 'changeSelected', this.setThread, this);

        this.app.on('package:changed', function() {
            // Событие кидается при инициализации
            if (this.__packageInitValue) {
                this.__packageInitValue = false;
                return;
            }
            view.value = null;
        }, this);

        region.show(view);
    }
});

module.exports = ThreadsController;
