var app = require('app'),
    BemItemView = require('common/bemItemView'),
    selectItemViewMixin = require('common/selectItemViewMixin'),
    Base = BemItemView.extend(selectItemViewMixin);

var PackagesView = Base.extend({
    template: require('templates/package-control'),

    ui: {
        select: ['.js-package', 'select'],
        addButton: ['.js-add', 'button'],
        editButton: ['.js-edit', 'button']
    },

    events: {
        'change @ui.select': 'onChange',
        'click @ui.editButton': 'edit',
        'click @ui.addButton': 'add',
    },

    modelEvents: {
        'change': 'updateEditButton'
    },

    initialize: function(options) {
        this.selectInit(options);

        this.on('changeSelected', this.updateEditButton, this);
    },

    onRender: function() {
        this.updateOptions();
        this.updateAddButton();
        this.updateEditButton();
    },

    updateOptions: function() {
        var data = this.collection.map(function(package) {
                return { item: 'option', value: package.get('id'), content: package.get('title') };
            });

        this.ui.select.setOptions(data, this.value);
    },

    updateAddButton: function() {
        if (app.config.packageAddUrl) {
            this.ui.addButton.delMod('disabled');
        } else {
            this.ui.addButton.setMod('disabled', 'yes');
        }
    },

    updateEditButton: function() {
        if (this.model && this.model.editUrl()) {
            this.ui.editButton.delMod('disabled');
        } else {
            this.ui.editButton.setMod('disabled', 'yes');
        }
    },

    edit: function() {
        window.open(this.model.editUrl(), '_blank');
    },

    add: function() {
        window.open(app.config.packageAddUrl, '_blank');
    }
});

module.exports = PackagesView;
