var createCursor;

var buttonHtml = function(text) {
    return '<div style="border-bottom:3px solid #933;line-height:18px;">' + text + '</div>';
};

var select = function(controller) {
    var app = controller.app;

    var behaviorSelectClickHandler = function(options) {
        var model = options.model,
            geoEvent = options.geoEvent;

        geoEvent.preventDefault();

        var text = [
            gettext('Добавить станцию типа'),
            model.getTypeTitle(),
            gettext('к рейсу типа'),
            app.currentThread.getTypeTitle(),
            '?'
        ].join(' ');

        if (+model.get('t_type_id') === +app.currentThread.get('t_type_id') || confirm(text)) {
            controller.addStation(model);
        }
    };
    
    var selectButton = new ymaps.control.Button({ data: { content: buttonHtml(gettext('Выбор')) } });
    selectButton.disable();

    selectButton.events.add('select', function() {
        controller.clearInsertion();
        app.modules.wwwStations.on('click', behaviorSelectClickHandler);
    });
    selectButton.events.add('deselect', function() {
        app.modules.wwwStations.off('click', behaviorSelectClickHandler);
    });

    return selectButton;
};

var create = function(controller) {
    var app = controller.app;

    var behaviorCreateClickHandler = function(e) {
        var position = e.get('coordPosition');

        app.modules.wwwStations.create(position, {
            title: '',
            lon: position[0],
            lat: position[1],
            't_type_id': app.currentThread.get('t_type_id'),
            'majority_id': app.config.defaults.majority
        });

        app.modules.wwwStations.on('created', function(options) {
            controller.addStation(options.model);
        });
    };


    var createButton = new ymaps.control.Button({ data: { content: buttonHtml(gettext('Создать')) } });
    createButton.disable();

    createButton.events.add('select', function() {
        controller.clearInsertion();
        createCursor = app.map.cursors.push('crosshair');
        app.map.events.add('click', behaviorCreateClickHandler);
    });
    createButton.events.add('deselect', function() {
        createCursor && createCursor.remove();
        app.map.events.remove('click', behaviorCreateClickHandler);
    });

    return createButton;
};

module.exports = {
    select: select,
    create: create
};
