var _ = require('underscore'),
    BalloonPlacemark = require('common/balloonPlacemark'),
    StationForm = require('modules/red_stations/form');


var StationPlacemark = BalloonPlacemark.extend({
    modelEvents: {
        'change:lon change:lat': 'updatePlacemarkCoordinates',
        'change:number': 'updateIconContent'
    },

    initialize: function(options) {
        this.listenTo(this.model, 'hover', function() {
            this.setStyle('yellow');
        }, this);

        this.listenTo(this.model, 'unhover', function() {
            this.setStyle('green');
        }, this);

        this.listenTo(this.model, 'change', function() {
            this.setStyle('green');
        }, this);

        this.setStyle('green');
    },

    iconContent: function() {
        return this.model.get('number');
    },

    hintContent: function() {
        return this.model.get('www_station').get('id') + '<br />' + this.model.get('www_station').get('title');
    },

    onBalloonOpen: function() {
        this.balloonView = new StationForm({
            model: this.model
        });

        this.listenTo(this.balloonView, 'close', function() {
            this.geoObject.balloon.close();
        }, this);

        this.geoObject.properties.set('balloonContent', this.balloonView.render().el);
    },

    onBalloonClose: function() {
        this.balloonView && this.balloonView.close();
        this.geoObject.properties.set('balloonContent', this.balloonContent);
        this.model.trigger('unhover');
    },

    updateIconContent: function() {
        this.geoObject.properties.set('iconContent', _.result(this, 'iconContent'));
    }

});

module.exports = StationPlacemark;
