var app = require('app'),
    Backbone = require('backbone'),
    _ = require('underscore'),
    BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions');

var ThreadForm = BemItemView.extend({
    template: require('templates/metathread-form'),

    ui: {
        type: ['.js-type', 'select'],
        subtype: ['.js-subtype', 'select'],
        supplier: ['.js-supplier', 'select'],
        number: ['.js-number', 'input'],
        title: ['.js-title', 'input'],
        applyBaseStations: ['.js-base-stations', 'radio-button'],
        scheme: ['.js-scheme', 'input'],
        comment: ['.js-comment', 'input'],

        save: ['.js-save', 'button'],
        create: ['.js-create', 'button'],
        delete: ['.js-delete', 'button'],
        clone: ['.js-clone', 'button'],
        cloneReversed: ['.js-clone-reversed', 'button'],
        import: ['.js-import', 'button'],
        importPackage: ['.js-import-package', 'button']
    },

    events: {
        'click @ui.save': 'onSave',
        'click @ui.create': 'onCreate',
        'click @ui.delete': 'onDelete',
        'click @ui.clone': 'onClone',
        'click @ui.cloneReversed': 'onCloneReversed',
        'click @ui.import': 'onImport',
        'click @ui.importPackage': 'onImportPackage'
    },

    onRender: function () {
        // XXX ожидаем вставку в dom потому что select отрисовывается через обработчик live-события
        setTimeout(_.bind(function () {
            // Transport type
            this.ui.type.setOptions(makeOptions('t_types'), this.model.get('t_type_id'));
            this.ui.subtype.setOptions(makeOptions('t_subtypes'), this.model.get('t_subtype_id'));

            // Supplier
            this.ui.supplier.setOptions(makeOptions('suppliers'), this.model.get('supplier_id'));
        }, this), 0);

        this.ui.applyBaseStations.val(this.model.get('apply_base_stations') ? 'yes' : 'no');
    },

    onCreate: function() {
        if (!confirm(gettext('Создать мета-рейс?'))) {
            return;
        }

        this.trigger('create');
    },

    onDelete: function() {
        if (!confirm(gettext('Удалить мета-рейс?'))) {
            return;
        }
        this.model.destroy();
    },

    onClone: function() {
        if (!confirm(gettext('Скопировать мета-рейс?'))) {
            return;
        }

        this.model.clone(function(model) {
            app.trigger('thread:set', {
                model: model
            });
        });
    },

    onCloneReversed: function() {
        if (!confirm(gettext('Скопировать обратный мета-рейс?'))) {
            return;
        }

        this.model.clone(true, function(model) {
            app.trigger('thread:set', {
                model: model
            });
        });
    },

    onImport: function() {
        if (!confirm(gettext('Импортировать мета-рейс?'))) {
            return;
        }

        var popup = window.open('about:blank', '_blank');
        Backbone.ajax({
            url: _.result(this.model, 'url') + '/import',
            success: function(res) {
                // Чтобы страница гарантированно не скачивалась
                popup.history.replaceState({}, 'Import', window.location.origin + res.url);
                $.get(res.url, function(html) {
                    popup.document.write('<pre>' + html + '</pre>');
                });
            },
            error: function() {
                popup.close();
            }
        });
    },

    onImportPackage: function() {
        if (!confirm(gettext('Импортировать пакет?'))) {
            return;
        }

        var popup = window.open('about:blank', '_blank');
        Backbone.ajax({
            url: _.result(this.model.collection.package, 'url') + '/import',
            success: function(res) {
                popup.history.replaceState({}, 'Import', window.location.origin + res.url);
                $.get(res.url, function(html) {
                    popup.document.write('<pre>' + html + '</pre>');
                });
            },
            error: function() {
                popup.close();
            }
        });
    },

    onSave: function() {
        this.model.save({
            't_type_id': +this.ui.type.val(),
            't_subtype_id': +this.ui.subtype.val(),
            'supplier_id': +this.ui.supplier.val(),
            number: this.ui.number.val(),
            title: this.ui.title.val(),
            'apply_base_stations': this.ui.applyBaseStations.val() === 'yes',
            scheme: this.ui.scheme.val(),
            comment: this.ui.comment.val()
        });
    }
});

module.exports = ThreadForm;
