var _ = require('underscore'),
    Marionette = require('marionette'),
    ThreadCollection = require('modules/red_threads/collection'),
    ThreadModel = require('modules/red_threads/model'),
    ThreadsView = require('modules/red_threads/view'),
    NoThreadsView = require('modules/red_threads/noThreadsView'),
    ThreadForm = require('modules/red_threads/form');


var ThreadsController = Marionette.Controller.extend({
    initialize: function(options) {
        this.app = options.app;
        this.initValue = options.moduleOptions.threads.id;
        this.__packageInitValue = options.moduleOptions.packages.id;
        this.collection = new ThreadCollection();

        this.app.on('package:changed', this.setPackage, this);
        this.app.on('thread:set', this.setThread, this);
    },

    // Api
    setPackage: function(options) {
        options = options || {};

        var package = options.model;

        this.collection.setPackage(package);

        if (!package) {
            this.collection.reset();
        } else {
            this.collection.fetch({ reset: true });
        }
    },

    setThread: function(options) {
        options = options || {};
        this.app.currentThread = options.model;
        this.app.trigger('thread:changed', options);

        // Новая модель создана через интерфейс
        if (options.model && this.collection.indexOf(options.model) === -1) {
            this.collection.add(options.model);
        }

        var threadType;
        if (options.model) {
            threadType = options.model.get('t_type_id');
        } else {
            threadType = this.app.config.transportType;
        }
        this.app.trigger('wwwStations:setSelected', threadType);
    },

    createThread: function(options) {
        options = options || {};
        options = _.defaults(options, {
            'package_id': this.app.currentPackage.get('id'),
            't_type_id': this.app.currentPackage.get('t_type_id'),
            't_subtype_id': this.app.currentPackage.get('t_subtype_id'),
            'supplier_id': this.app.config.defaults.supplier,
            number: '',
            title: '',
            'apply_base_stations': 'yes',
            scheme: '',
            comment: ''
        });

        var _this = this,
            model = new ThreadModel(options);

        model.save(null, {
            success: function() {
                _this.app.trigger('thread:set', {
                    model: model
                });
            }
        });
    },

    // Блоки
    selectBlock: function(region) {
        this._selectRegion = region;

        var view = new ThreadsView({
            collection: this.collection,
            value: this.initValue
        });

        this.listenTo(view, 'changeSelected', this.setThread, this);

        this.app.on('package:changed', function() {
            // Событие кидается при инициализации
            if (this.__packageInitValue) {
                this.__packageInitValue = false;
                return;
            }
            view.value = null;
        }, this);

        this.app.on('thread:set', function(options) {
            options = options || {};
            if (options.model) {
                view.value = options.model.get('id') || options.model.cid;
            } else {
                view.value = null;
            }
            view.updateOptions();
        }, this);

        region.show(view);
    },

    formBlock: function(region) {
        this._formRegion = region;
        this.app.on('thread:changed', this._showFormBlock, this);
    },

    _showFormBlock: function(options) {
        var view;

        if (!options || !options.model) {
            view = new NoThreadsView();
        } else {
            view = new ThreadForm({
                model: options.model
            });
        }

        this.listenTo(view, 'create', this.createThread, this);

        this._formRegion.show(view);
    }
});

module.exports = ThreadsController;
