var BemItemView = require('common/bemItemView');


var NoThreadsView = BemItemView.extend({
    ui: {
        createButton: ['.js-create', 'button']
    },

    events: {
        'click @ui.createButton': 'onCreate'
    },

    getTemplate: function() {
        var html = BEMHTML.apply({
            block: 'island',
            mods: { type: 'actions' },
            elem: 'row',
            content: {
                block: 'button',
                mods: { size: 's' },
                mix: { block: 'js-create' },
                content: gettext('Создать мета-рейс')
            }
        });

        return function() {
            return html;
        };
    },

    onCreate: function() {
        if (!confirm(gettext('Создать мета-рейс?'))) {
            return;
        }

        this.trigger('create');
    }
});

module.exports = NoThreadsView;
