var BackboneYmaps = require('Backbone.Ymaps'),
    PlacemarkCollection = require('modules/www_stations/placemarkCollection'),
    RegionPlacemark = require('modules/regions/placemark'),
    SettlementForm = require('modules/regions/settlementForm');

var RegionPolygon = BackboneYmaps.Polygon.extend({
    events: {
        'balloonopen': 'onBalloonOpen',
        'balloonclose': 'onBalloonClose',
        'click': 'onClick',
        'dblclick': 'onDblClick'
    },

    balloonContent: gettext('Загрузка...'),

    polygonOptions: {
        fillOpacity: 0.6,
        openBalloonOnClick: false
    },

    bgColors: [
        '#F08080',
        '#FFE4B5',
        '#ADD8E6',
        '#98FB98',
        '#F0FFF0',
        '#7FFFD4',
        '#FFA500',
        '#A9A9A9',
        '#808000',
        '#7B68EE'
    ],

    initialize: function () {
        // Случайный цвет
        this.setFillColor(this.bgColors[Math.floor(Math.random() * this.bgColors.length)]);

        // Отображение привязанных точек
        this.stations = new PlacemarkCollection({
            geoItem: RegionPlacemark,
            collection: this.model.stations,
            map: this.map
        });

        this.stations.render();
    },

    hintContent: function() {
        return this.model.get('title');
    },

    onBalloonOpen: function() {
        this.balloonView = new SettlementForm({
            model: this.model
        });

        this.listenTo(this.balloonView, 'close', function() {
            this.geoObject.balloon.close();
        }, this);

        this.geoObject.properties.set('balloonContent', this.balloonView.render().el);
    },

    onBalloonClose: function() {
        this.balloonView && this.balloonView.close();
        this.geoObject.properties.set('balloonContent', this.balloonContent);
    },

    onClick: function() {
        this.parent.trigger('item:selected', {
            model: this.model
        });
    },

    onDblClick: function() {
        this.geoObject.balloon.open();
    }
});

module.exports = RegionPolygon;
