var _ = require('underscore'),
    BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions');

var SettlementForm = BemItemView.extend({
    template: require('templates/settlement-form'),

    ui: {
        id: '.js-id',
        title: ['.js-title', 'input'],
        titleRu: ['.js-title-ru', 'input'],
        titleUk: ['.js-title-uk', 'input'],
        titleTr: ['.js-title-tr', 'input'],
        titleEn: ['.js-title-en', 'input'],
        country: ['.js-country', 'related-object'],
        region: ['.js-region', 'related-object'],
        majority: ['.js-majority', 'select'],

        cancel: ['.js-cancel', 'button'],
        save: ['.js-save', 'button']
    },

    events: {
        'click @ui.cancel': 'cancel',
        'click @ui.save': 'save'
    },

    attrsMapping: {
        title: 'title',
        titleRu: 'title_ru',
        titleUk: 'title_uk',
        titleTr: 'title_tr',
        titleEn: 'title_en'
    },

    relatedAttrs: ['region', 'country'],

    onRender: function() {
        _.each(this.attrsMapping, function(modelAttr, uiAttr) {
            this.ui[uiAttr].val(this.model.get(modelAttr) || '');
        }, this);

        _.each(this.relatedAttrs, function(attr) {
            var val = this.model.get(attr);
            if (val) {
                this.ui[attr].val(val.id, val.title);
            }
        }, this);

        this.ui.majority.setOptions(
            makeOptions('city_majorities'),
            this.model.get('majority_id')
        );
    },

    cancel: function() {
        this.trigger('close');
    },

    save: function() {
        var newData = {};

        _.each(this.attrsMapping, function(modelAttr, uiAttr) {
            this.model.set[modelAttr] = this.ui[uiAttr].val();
        }, this);

        _.each(this.relatedAttrs, function(attr) {
            var val = this.ui[attr].val();
            if (!val) {
                newData[attr] = null;
            } else {
                newData[attr] = { id: val };
            }
        }, this);

        newData['majority_id'] = +this.ui.majority.val();

        this.model.save(newData, {
            wait: true
        });

        this.trigger('close');
    }
});

module.exports = SettlementForm;
