var _ = require('underscore'),
    app = require('app'),
    getIconStyle = require('modules/regions/getIconStyle'),
    StationView = require('modules/blue_stations/sidebarItemView');

var View = StationView.extend({
    template: require('templates/purple-station-item'),

    ui: _.defaults(
        {
            icon: '.js-icon',
            button: ['.js-edit', 'button'],
            buttonPopup: ['.js-edit', 'popup-on-hover']
        },
        StationView.prototype.ui
    ),

    modelEvents: {
        'change': 'render',
        'hover': 'addClassHover',
        'unhover': 'removeClassHover'
    },

    onRender: function() {
        if (!this.model.get('hidden')) {
            this.ui.link.setMod('mapped', 'yes');
        }

        this.ui.icon.attr(
            'src',
            app.config.staticUrl + 'images/' + getIconStyle(this.model) + '.svg'
        );
    },

    addClassHover: function() {
        this.ui.link.setMod('hover', 'yes');
    },

    removeClassHover: function() {
        this.ui.link.delMod('hover');
    }
});

module.exports = View;
