var app = require('app'),
    Backbone = require('Backbone'),
    WwwStationModel = require('modules/www_stations/model');


var Collection = Backbone.Collection.extend({
    model: WwwStationModel,

    initialize: function() {
        // Привязка станции к городу требует перерисовки карты
        this.on('change:settlement', function() {
            this.trigger('redrawNeeded');
        }, this);
    },

    url: function() {
        return app.config.noSettlementStationsUrl;
    },

    parse: function(data, options) {
        if (data.error) {
            app.trigger('alert:show', {
                msg: data.error,
                type: 'error'
            });
            options.remove = false;
        } else {
            app.trigger('alert:hide');
        }

        return data.stations || [];
    },

    getParams: function() {
        var center = app.map.getCenter(),
            bounds = app.map.getBounds();

        return {
            center: '' + center[0] + ',' + center[1],
            span: '' + (bounds[1][0] - bounds[0][0]) + ',' + (bounds[1][1] - bounds[0][1]),
            zoom: app.map.getZoom(),
            't_types': this.stationTypes
        };
    },

    fetch: function(options) {
        options = options || {};
        options.data = this.getParams();
        options.traditional = true;

        return Backbone.Collection.prototype.fetch.call(this, options);
    }
});

module.exports = Collection;
