var app = require('app'),
    _ = require('underscore'),
    Backbone = require('Backbone'),
    GeoCollection = require('common/geoCollection'),
    WwwStationModel = require('modules/www_stations/model');

var WwwStationCollection = GeoCollection.extend({
    model: WwwStationModel,

    initialize: function(models, options) {
        this.stationTypes = options.stationTypes;
        this.settlements = new Backbone.Collection();
        this.psevdoGortrans = new Backbone.Collection();
    },

    url: function() {
        return app.config.wwwStationsUrl;
    },

    parse: function(data) {
        if (!data.stations) {
            app.trigger('alert:show', {
                msg: gettext('слишком много остановок, увеличьте масштаб'),
                type: 'error'
            });
        } else {
            app.trigger('alert:hide');
        }

        this.settlements.reset(_.values(data.settlements) || []);
        this.psevdoGortrans.reset(data['gort_stations'] || []);

        return data.stations || [];
    },

    getParams: function() {
        var center = app.map.getCenter(),
            bounds = app.map.getBounds();

        return {
            center: '' + center[0] + ',' + center[1],
            span: '' + (bounds[1][0] - bounds[0][0]) + ',' + (bounds[1][1] - bounds[0][1]),
            zoom: app.map.getZoom(),
            't_types': this.stationTypes
        };
    },

    fetch: function(options) {
        options = options || {};
        options.data = this.getParams();
        options.traditional = true;

        return Backbone.Collection.prototype.fetch.call(this, options);
    }
});

module.exports = WwwStationCollection;
