var _ = require('underscore'),
    cookie = require('jquery.cookie');


var imagesDirUrl = '/static/rasp/rainbow/';

var items = [
    { title: gettext('Автобусы'), tTypes: ['bus'], color: 'yellow' },
    { title: gettext('Городской транспорт'), tTypes: ['urban'], color: 'black' },
    { title: gettext('Поезда и пригородные поезда'), tTypes: ['train', 'local_train'], color: 'green' },
    { title: gettext('Псевдо-гортранс'), tTypes: ['pseudo-gortrans'], color: 'grey' },
    { title: gettext('Речной и морской транспорт'), tTypes: ['water'], color: 'blue' },
    { title: gettext('Самолеты и вертолеты'), tTypes: ['plane', 'helicopter'], color: 'orange' }
];
items = _.sortBy(items, 'title');

var ListBoxItemLayoutHtml = [
'<ymaps class="ymaps-b-listbox-panel__item [if state.selected]ymaps-b-form-checkbox_checked_yes[endif]">',
    '<ymaps class="ymaps-b-form-checkbox ymaps-b-form-checkbox_size_13 ymaps-i-bem checkbox">',
        '<input class="ymaps-b-form-checkbox__checkbox" type="checkbox"/>',
        '<i class="ymaps-b-form-checkbox__bg"><i class="ymaps-b-form-checkbox__tick"></i></i>',
    '</ymaps>',
    '<img src="$[data.image]"> ',
    '<input type="number" class="zoom" style="width:40px;" min="8" max="18" value="$[data.zoom]"> ',
    '<ymaps class="ymaps-b-listbox-panel__item-link ymaps-b-listbox-panel__item-link_type_label label">',
        '$[data.content]',
    '</ymaps>',
'</ymaps>'
].join('');

function WwwStationsControl(controller) {
    this.controller = controller;

    this.tTypes = controller.stationTypes;

    this._createListItemLayout();
    this.controlItems = _.map(items, this._makeListItem, this);

    this.control = new ymaps.control.ListBox({
        data: {
            title: gettext('Остановки')
        },
        items: this.controlItems
    });

    this.onChangeLayers();
}

_.extend(WwwStationsControl.prototype, {
    _createListItemLayout: function() {
        var control = this,
            ListBoxItemLayout;

        ListBoxItemLayout = ymaps.templateLayoutFactory.createClass(ListBoxItemLayoutHtml, {
            build: function () {
                ListBoxItemLayout.superclass.build.call(this);

                var layout = this,
                    el = $(this.getElement());

                el.find('.zoom').on('change', function(e) {
                    var data = layout.getData().data;
                    var zoom = e.target.value,
                        cookieName = data.get('cookieName');

                    control.saveZoom(cookieName, zoom, data);
                });

                el.find('.checkbox, .label').on('click', function() {
                    var state = layout.getData().state;
                    state.set('selected', !state.get('selected'));
                });
            }
        });

        this.ListBoxItemLayout = ListBoxItemLayout;
    },

    _makeListItem: function(item) {
        var zoom = parseInt(cookie('map_' + item.tTypes[0] + '_zoom'), 10) || 10,
            controlItem;

        controlItem = new ymaps.control.ListBoxItem(
            {
                data: {
                    content: item.title,
                    tTypes: item.tTypes,
                    zoom: zoom,
                    image: imagesDirUrl + item.color + 'Dot.png',
                    cookieName: item.tTypes.map(function(n) { return 'map_' + n + '_zoom'; })
                }
            }, {
                checkbox: true,
                selectOnClick: false,
                layout: this.ListBoxItemLayout
            }
        );

        if (_.intersection(this.tTypes, item.tTypes).length) {
            controlItem.select();
        }

        controlItem.events.add(['select', 'deselect'], this.onChangeLayers, this);

        return controlItem;
    },

    onChangeLayers: function() {
        var selectedItems = _.filter(this.controlItems, function(item) {
            return item.isSelected();
        });

        this.tTypes = _.flatten(_.map(selectedItems, function(item) {
            return item.data.get('tTypes');
        }));

        this.controller.app.trigger('wwwStations:typeUpdate', this.tTypes);
    },

    saveZoom: _.debounce(function(cookieName, zoom, data) {
        data.set('zoom', zoom);
        _.each(cookieName, function(n) {
            cookie(n, zoom, { path: '/admin/' });
        });
        
        this.controller.app.trigger('wwwStations:update');
    }, 500)
});


module.exports = function(controller) {
    var klass = new WwwStationsControl(controller);
    return klass.control;
};
