var BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions');

var WwwStationForm = BemItemView.extend({
    template: require('templates/www-station-form'),

    ui: {
        id: '.js-id',
        title: '.js-title',
        adminLink: '.js-admin-link',
        majority: ['.js-majority', 'select'],
        save: ['.js-save', 'button']
    },

    events: {
        'click @ui.save': 'save'
    },

    templateHelpers: function() {
        return {
            adminUrl: this.model.getAdminUrl()
        };
    },

    onRender: function() {
        this.ui.majority.setOptions(
            makeOptions('station_majorities'),
            this.model.get('majority_id')
        );
    },

    save: function() {
        this.model.set('majority_id', +this.ui.majority.val());
        this.model.save();
        this.trigger('close');
    }
});

module.exports = WwwStationForm;
