var _ = require('underscore'),
    Marionette = require('Marionette');


var SidebarView = Marionette.Layout.extend({

    getTemplate: function() {
        var blocks = this.blocks;
        return function() {
            var template = [];

            _.each(blocks, function(block, i) {
                template.push('<div id="sidebar-block-' + i + '"></div>');
            });

            return template.join('');
        };
    },

    initialize: function(options) {
        this.app = options.app;
        this.blocks = options.sidebarBlocks;

        _.each(this.blocks, function(module, i) {
            this.addRegion('block' + i, '#sidebar-block-' + i);
        }, this);

        this.app.sidebarRegion.show(this);
    },

    onRender: function() {
        _.each(this.blocks, function(module, i) {
            var method = 'getBlock';

            if (_.isArray(module)) {
                method = module[1];
                module = module[0];
            }

            this.app.modules[module][method](this['block' + i]);
        }, this);
    }

});

module.exports = SidebarView;
