var Backbone = require('backbone');

var success = function(data, textStatus, jqXHR) {
    var dfd = $.Deferred(),
        humanError = this.humanError || '';

    if (humanError) {
        humanError += '\n';
    }

    if (data.status && data.status !== 'ok') {
        dfd.reject(jqXHR, textStatus, data.message || 'Status error');

        if (data.message) {
            alert(humanError + data.message);
        } else {
            alert(humanError + gettext('Ошибка получения данных с сервера'));
        }
        return dfd;
    }

    dfd.resolve(data, textStatus, jqXHR);

    return dfd;
};

var error = function(jqXHR, textStatus, errorThrown) {
    if (textStatus === 'abort') {
        return;
    }

    var humanError = this.humanError || '';

    if (humanError) {
        humanError += '\n';
    }

    alert(humanError + gettext('Ошибка связи с сервером'));
};

// Переопределение Backbone.ajax, для единой обработки ошибок внутри всего Backbone
// И ajax вызовов внутри приложения
Backbone.ajax = function() {
    var args = Array.prototype.slice.call(arguments, 0),
        ajaxSuccess = function() {};

    if (args.length > 0 && args[0] !== null && typeof args[0] === 'object') {
        ajaxSuccess = args[0]['success'] || ajaxSuccess;
        delete args[0]['success'];
    }

    var jqXHR = $.ajax.apply(Backbone.$, args);

    jqXHR.then(success, error).done(ajaxSuccess);

    return jqXHR;
};
