var app = require('app'),
    _ = require('underscore');


function geoCoords2Pixels(coords) {
    var zoom = app.map.getZoom();

    if (zoom > 10) {
        zoom = 10;
    }

    return app.map.options.get('projection').toGlobalPixels(coords, zoom);
}

function pixels2GeoCoords(coords) {
    var zoom = app.map.getZoom();

    if (zoom > 10) {
        zoom = 10;
    }

    return _.map(coords, function(point) {
        return app.map.options.get('projection').fromGlobalPixels(point, zoom);
    });
}

function center2Bounds(center) {
    var pixelSize = app.map.container.getSize(),
        pixelCenter = geoCoords2Pixels(center);

    return pixels2GeoCoords([
        [pixelCenter[0] - pixelSize[0] / 2, pixelCenter[1] - pixelSize[1] / 2],
        [pixelCenter[0] + pixelSize[0] / 2, pixelCenter[1] + pixelSize[1] / 2]
    ]);
}

module.exports = {
    geoCoords2Pixels: geoCoords2Pixels,
    pixels2GeoCoords: pixels2GeoCoords,
    center2Bounds: center2Bounds
};
