var blocks = blocks || {};

blocks['b-page'] = function (data) {
    return [
        {
            block: 'i-global',
            params: {
                lang: data.lang
            }
        },
        {
            block: 'b-page',
            title: data.title || 'Геоадмин.Прото',
            head: [
                { elem: 'css', url: data.staticUrl + 'desktop.bundles/common/_common.css', ie: false },
                { elem: 'css', url: data.staticUrl + 'desktop.bundles/common/_common', ie: true }
            ],
            mods: { theme: 'normal' },
            content: [
                {
                    elem: 'main',
                    mix: { block: 'js-placeholder', mods: { view: 'main' }},
                    content: [
                        blocks['header'](data),
                        {
                            block: 'maps',
                            attrs: { id: 'maps' },
                            js: true
                        },
                        {
                            block: 'island',
                            mods: { type: 'float', view: 'sidebar' },
                            js: true,
                            content: ''
                        },
                        {
                            block: 'paranja',
                            mods: { theme: 'rasp' }
                        },
                        {
                            block: 'notification',
                            content: 'Загрузка...'
                        }
                    ]
                },
                { block: 'i-jquery', mods: { version: '1.8.3' } },
                { elem: 'js', url: '/jsi18n/?lang=' + data.lang },
                { elem: 'js', url: data.staticUrl + 'desktop.bundles/common/_common.' + data.lang + '.pub.js' },
                {
                    elem: 'js',
                    url: '//api-maps.yandex.ru/2.0/' +
                         '?load=package.standard,package.geoObjects,package.route,package.editor' +
                         '&lang=' + data.lang + '&coordorder=longlat'
                },
                { elem: 'js', url: data.staticUrl + 'desktop.bundles/index/_vendors.js' },
                { elem: 'js', content: 'var serverConfig = ' + JSON.stringify(data) + ';' },
                {
                    elem: 'js',
                    url: data.staticUrl + 'desktop.bundles/index/_' + data.adminType + '.' + data.lang + '.lmd.js'
                }
            ]
        }
    ];
};
