BEM.DOM.decl({ block: 'select', modName: 'search', modVal: 'yes' }, {

    // Хак в лего ломает фокус на инпуте
    _onButtonBlur: function() {
        if (this.isOpened() && this._isPopupFocused()) {
            return;
        }

        this.delMod('focused');
    },

    _performSearch: function(val) {
        var tokens;

        val = val.toLowerCase();
        tokens = val.split(/[\s|-]+/);

        tokens = $.map(tokens, function(token) {
            if (token.length >= 2) {
                return token;
            }
            return null;
        });

        this._items.each(function(i, item) {
            var $item = $(item),
                found = 0,
                j;

            for (j = 0; j < tokens.length; j++) {
                if ($item.text().toLowerCase().indexOf(tokens[j]) > -1) {
                    found += 1;
                }
            }

            if (found === tokens.length) {
                $item.show();
            } else {
                $item.hide();
            }
        });
    },

    _clearSearch: function() {
        this._items.each(function(i, item) {
            $(item).show();
        });
    },

    _search: function() {
        var self = this,
            val = this._input.val();

        if (val === this._oldVal) {
            return;
        }

        this._oldVal = val;
        this._searchTimeout && clearTimeout(this._searchTimeout);
        if (val.length < 2) {
            this._clearSearch();
            return;
        }

        this._searchTimeout = setTimeout(function() {
            self._performSearch(val);
        }, 300);
    },

    // К сожалению копи-паст из лего, т.к. похоже это меньшее зло
    _getPopup: function() {
        if (this._popup) {
            return this._popup;
        }

        var _this = this,
            jsParams = _this.params,
            blockName = _this.__self.getName(),
            list = {
                block: blockName,
                elem: 'list'
            },
            elemPopupMix = {
                block: blockName,
                elem: 'popup',
                elemMods: {}
            },
            blockPopupMods = {
                animate: 'no'
            },
            blockPopupParams = {
                directions: [ 'bottom-left', 'top-left' ]
            };

        // пробрасываем зарезервированные модификаторы из блока в элемент 'select__popup'
        ['size', 'layout', 'theme', 'width'].forEach(function(mod) {
            _this.hasMod(mod) && (elemPopupMix.elemMods[mod] = _this.getMod(mod));
        });

        // пробрасываем пользовательские модификаторы из js-параметра 'elemPopupMods' в элемент 'select__popup'
        $.extend(elemPopupMix.elemMods, jsParams.elemPopupMods);

        // пробрасываем пользовательские модификаторы из js-параметра 'popupMods' в блок 'popup'
        $.extend(blockPopupMods, jsParams.popupMods);

        // пробрасываем пользовательские параметры из js-параметра 'popupParams' в блок 'popup'
        $.extend(blockPopupParams, jsParams.popupParams);

        var popup = $(BEMHTML.apply({
                block: 'popup',
                mods: blockPopupMods,
                mix: [ elemPopupMix ],
                js: blockPopupParams,
                content: {
                    elem: 'content',
                    content: [
                        {
                            block: 'input',
                            mods: { size: 's' },
                            content: { elem: 'control' }
                        },
                        list
                    ]
                }
            }));

        (_this._popup = _this.findBlockOn(popup, 'popup'))
            .on({
                'show': function() {
                    _this._curItemIndex = _this._getSelectedIndex();

                    var current = _this._items.eq(_this._curItemIndex);
                    _this
                        .delMod(_this._items, 'selected')
                        .setMod(current, 'hovered', 'yes')
                        .setMod(current, 'selected', 'yes');
                },

                'outside-click': function(e, data) {
                    _this._isOutsideClicked(e, data) ?
                        e.preventDefault() : _this._blurButton();
                },

                'hide': function() {
                    _this._curItemIndex = -1;

                    _this
                        .delMod('opened')
                        .delMod(_this._items, 'hovered')
                        .delMod(_this.findElem(_this._popup.domElem, 'popup'), 'scrollable');
                }
            })
            .bindTo('mousedown', function(e) {
                e.preventDefault();
            });

        BEM.DOM.append(BEM.DOM.scope, _this._popup.domElem);

        // see `select__ui` for src
        _this._redrawList();

        /*
         * (HACK, LEGO-7251)
         * TODO: При рефакторинге - убрать, блок popup это уже умеет.
         */
        _this._outPopup = _this.findBlockOutside('button', 'popup');
        _this._outPopup && _this._outPopup.on('outside-click', function(e, data) {
                _this._popup.containsDomElem($(data.target)) &&
                    e.preventDefault();
            });

        this._input = _this._popup.findBlockInside('input');
        this._input.on('change', this._search, this);

        return _this._popup;
    }

});
