/**
 * Панель кнопок
 *
 * @param map
 * @param id
 * @param options
 * @constructor
 */
geomap.control.ButtonPanel = function (map, options, defaultId) {
    var self = this;
    geomap.control.ButtonPanel.superclass.constructor.apply(self, [map, options, defaultId]);
    geomap.control.HasData.prototype._init.call(self);

    self._buttonsSynchronizations = [];

    self.styleProvider = options.styleProvider || self.defaultStyleProvider;

    var title = options.title,
        btnGroupUid = self.uid + "-group",
        groupStyle = (options.style == 'vertical') ? 'btn-group-vertical' : 'btn-group';

    self.container.html(self._renderContainer(title, btnGroupUid, groupStyle));
    self._btnGroup = $('#' + btnGroupUid);
    self._title = $('#' + btnGroupUid + '-title');
    self.refresh();
};

extend(geomap.control.ButtonPanel, geomap.control.AbstractControl);

mixin(geomap.control.ButtonPanel.prototype, geomap.control.HasData.prototype);

mixin(geomap.control.ButtonPanel.prototype, {

    defaultDataProvider: function (map, callback) {
        var self = this,
            buttons = $.map(self.options.presets || [], function (presetId) {
                return {
                    preset: presetId
                }
            });
        if (self.options.buttons) {
            buttons = buttons.concat(self.options.buttons);
        }
        callback(buttons);
    },

    defaultStyleProvider: function (map, object) {
        var self = this;
        return 'btn-default';
    },

    defaultHandler: function (map, options) {
    },

    title: function(title) {
        this._title.html(title);
    },

    _beforeLayout: function () {
        var self = this;
        $.each(self._buttonsSynchronizations, function (i, sync) {
            sync.remove();
        });
        self._buttonsSynchronizations = [];
    },

    _doLayout: function (currentValue) {
        var self = this;
        self._btnGroup.html('');
        $.each(self.objects, function (i, buttonOptions) {
            var options = self._prepareButtonOptions(buttonOptions),
                buttonUid = self.uid + '-' + i,
                buttonTitle = self._objectTitle(options),
                handler = options.handler || self.defaultHandler,
                style = self.styleProvider.call(self, self.map, options),
                html = self._render(options, buttonUid, style, buttonTitle);

            self._btnGroup.append(html);
            var btn = $('#' + buttonUid);
            btn.bind('click', function (event) {
                handler.apply(self, [self.map, options]);
            });
            self._buttonsSynchronizations.push(self.map.readyState.onReady(function (ready) {
                geomap.utils.disable(btn, ready);
            }));
        });
    },

    _render: function (options, uid, style, title) {
        return '<button id="' + uid + '" type="button" class="btn ' + style + ' btn-sm">' + title + '</button>';
    },

    _renderContainer: function (title, uid, style) {
        return (title ? '<h5 id="' + uid + '-title">' + title + '</h5>' : '') + '<div id="' + uid + '" class="col-g-12 ' + style + '">';
    },

    _prepareButtonOptions: function (options) {
        var self = this,
            preset = options.preset;
        if (!preset) {
            return options;
        }
        var presetOptions = geomap.control.buttonPanelPresets[preset];
        if (!presetOptions) {
            throw 'Preset "' + preset + '" is not found';
        }
        options.title = options.title || presetOptions.title;
        options.handler = options.handler || presetOptions.handler;
        return options;
    }
});

geomap.control.buttonPanelPresets = {};
