geomap.control.HasData = function () {
};

mixin(geomap.control.HasData.prototype, {

    _init: function () {
        var self = this;

        self.dataProvider = self.options.dataProvider || self.defaultDataProvider;

        self.objects = [];
        self._objectIndex = {};
    },

    refresh: function (notFetch) {
        var self = this,
            currentValue = self.val ? self.val() : null;

        self.readyState.notReady();
        try {
            self._beforeRefresh();
            if (notFetch == true) {
                self._beforeLayout();
                self._doLayout(currentValue);
                self._afterLayout();
                self._afterRefresh();
                self.readyState.ready();
            } else {
                self._beforeFetchData();
                self.dataProvider(self.map, function (objects) {
                    try {
                        self.objects = objects;
                        self._objectIndex = geomap.utils.buildIndex(objects, function(object) {
                            return self._objectId(object);
                        });

                        self._afterFetchData();
                        self._beforeLayout();
                        self._doLayout(currentValue);
                        self._afterLayout();

                        if (self.val && self.objects.length > 0 && (!currentValue || !self._objectIndex[self._objectId(currentValue)])) {
                            self.val(self._defaultValue(), true);
                        }

                        self._afterRefresh();
                    } finally {
                        self.readyState.ready();
                    }
                });
            }
        } catch (e) {
            self.readyState.ready();
            throw e;
        }
    },

    _afterLayout: function () {
    },

    _afterRefresh: function () {
    },

    _afterFetchData: function () {
    },

    _beforeLayout: function () {
    },

    _beforeRefresh: function () {
    },

    _beforeFetchData: function () {
    },

    _getValueById: function (id) {
        var self = this;
        return self._objectIndex[id];
    }

});
