/**
 * Базовый класс селектов
 *
 * @param map
 * @param options
 * @param defaultLabel
 * @param uidPostfix
 * @constructor
 */
geomap.control.ListBox = function (map, options, defaultLabel, defaultId) {
    var self = this;

    geomap.control.ListBox.superclass.constructor.apply(self, [map, options, defaultId]);
    geomap.control.HasData.prototype._init.call(self);
    geomap.control.HasValue.prototype._init.call(self);

    self._label = options.label || defaultLabel;
    self._showRefreshBtn = options.refresh || false;
    self._synchronizations = [];
    self._silent = false;

    self._beforeRefresh();
};

extend(geomap.control.ListBox, geomap.control.AbstractControl);

mixin(geomap.control.ListBox.prototype, geomap.control.HasValue.prototype);

mixin(geomap.control.ListBox.prototype, geomap.control.HasData.prototype);

mixin(geomap.control.ListBox.prototype, {

    _setValue: function (value) {
        var self = this;
        if (self.select) {
            var oldSilent = self._silent;
            self._silent = true;
            try {
                self.select.val(value);
                //self.select.selectpicker('refresh');
            } finally {
                self._silent = oldSilent;
            }
        }
    },

    _defaultValue: function () {
        var self = this,
            value = geomap.control.HasValue.prototype._defaultValue.call(self);

        return value ? value : self.objects[0];
    },

    _doLayout: function (currentValue) {
        var self = this,
            selectUid = self.uid + "-select";

        self.container.html(self._layout(self._selectBoxHtml(selectUid, currentValue)));

        self.select = $('#' + selectUid);
        //self.select.selectpicker('refresh');
        self.select.bind('change', function (event) {
            if (!self._silent) {
                self.val(self._getValueById(self.select.val()));
            }
        });

        self._synchronizations.push(self.map.readyState.onReady(function (ready) {
            geomap.utils.disable(self.select, ready);
        }));

        if (self._showRefreshBtn) {
            var btn = $('#' + selectUid + '_refresh');
            btn.bind("click", function () {
                self.refresh();
            });
            self._synchronizations.push(self.map.readyState.onReady(function (ready) {
                geomap.utils.disable(btn, ready);
            }));
        }
    },

    _layout: function (selectHtml) {
        return '<div class="form-group ListBox-group">' + selectHtml + '</div>';
    },

    _beforeRefresh: function () {
        var self = this;
        $.each(self._synchronizations, function (i, sync) {
            sync.remove();
        });
        self._synchronizations = [];
        self.container.html('<div class="form-group ListBox-group">' +
                                '<label for="' + self.uid + '-refresh" class="control-label col-g-2">' + self._label + '</label>' +
                                '<div class="input-group col-g-10" >' +
                                '<span id="' + self.uid + '-refresh" class="geomap-ListBox-refresh">' +
                                gettext('Подождите') +
                                '</span></div></div>');
    },

    _selectBoxHtml: function (id, selected) {
        var self = this,
            selectedId = self._objectId(selected),
            html =
                ' <label for="' + id + '" class="control-label col-g-2">' + self._label + '</label>' +
                    ' <div class="input-group col-g-10">' +
                    '  <select name="' + id + '" id="' + id + '" class="selectpicker show-tick form-control" data-live-search="true">';

        if (self.objects) {
            $.each(self.objects, function (i, obj) {
                var objectId = self._objectId(obj),
                    selectedHtml = selectedId == objectId ? 'selected' : '';
                html = html + '<option value="' + objectId + '" ' + selectedHtml + '>' + self._objectTitle(obj) + '</option>';
            });
        }
        html = html + '  </select>';
        if (self._showRefreshBtn) {
            html = html + '<span class="input-group-btn">' +
                '    <button id="' + id + '_refresh" type="button" class="btn btn-default">' +
                '        <img src="' + self.map.resourceUrl('/rasp/view-refresh.png') + '" alt="' + gettext('Обновить') + '"/>' +
                '    </button>' +
                '</span>';
        }
        html = html + '</div>';
        return html;
    }

});

