/**
 * Селект выбора пакета
 *
 * @param map
 * @param options
 * @constructor
 */
geomap.control.Package = function (map, options) {
    var self = this;
    geomap.control.Package.superclass.constructor.apply(self, [map, options, gettext('Пакет'), 'package']);
    self._editBtnUid = self.uid + '-edit';
    self._addBtnUid = self.uid + '-add';

    self._redDot = self.map.resourceUrl("rasp/rainbow/redDot.png");
};

extend(geomap.control.Package, geomap.control.ListBox);

mixin(geomap.control.Package.prototype, {

    bind: function () {
        var self = this,
            stationLayers = self.map.controls.stationLayers;

        if (stationLayers) {
            stationLayers.addStationIconImageInterceptor(function(station) {
                return station.t_type_code = self.val().t_type_code ? self._redDot : null;
            });
        }
    },

    _layout: function (selectHtml) {
        var self = this;
        return '<div class="form-group ListBox-group">' + selectHtml + '<div>' +
            '   <button id="' + self._editBtnUid + '" type="button" class="btn btn-link btn-xsm">' + gettext('Изменить') + '</button>' +
            '   <button id="' + self._addBtnUid + '" type="button" class="btn btn-link btn-xsm">' + gettext('Добавить новый') + '</button>' +
            '</div></div>';
    },

    _afterLayout: function () {
        var self = this,
            editBtn = $('#' + self._editBtnUid),
            addBtn = $('#' + self._addBtnUid);

        addBtn.bind("click", function () {
            window.open("/admin/importinfo/twostageimportpackage/add/", "_blank");
        });

        editBtn.bind("click", function () {
            window.open("/admin/importinfo/twostageimportpackage/" + self.select.val() + "/", "_blank")
        });
    },

    defaultDataProvider: function (map, callback) {
        $.getJSON('/admin/geomap/packages/', {}, function (data) {
            callback(data.objects);
        });
    }

});


